/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.LevenshteinDistance;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;

public class cvc_complex_type_2_4_aCodeAction
implements ICodeActionParticipant {
    private static final float MAX_DISTANCE_DIFF_RATIO = 0.4f;

    @Override
    public void doCodeAction(Diagnostic diagnostic, Range range, DOMDocument document, List<CodeAction> codeActions, SharedSettings sharedSettings, IComponentProvider componentProvider) {
        try {
            int offset = document.offsetAt(diagnostic.getRange().getStart());
            DOMNode node = document.findNodeAt(offset);
            if (node != null && node.isElement()) {
                DOMElement element = (DOMElement)node;
                String localName = element.getLocalName();
                Collection<CMElementDeclaration> possibleElements = cvc_complex_type_2_4_aCodeAction.getPossibleElements(element, componentProvider);
                if (possibleElements != null) {
                    Range endRange;
                    Range startRange;
                    TreeSet<Object> otherElementNames = new TreeSet<Object>(Collator.getInstance());
                    TreeSet<Object> similarElementNames = new TreeSet<Object>(Collator.getInstance());
                    for (CMElementDeclaration possibleElement : possibleElements) {
                        String possibleElementName = possibleElement.getName();
                        if (cvc_complex_type_2_4_aCodeAction.isSimilar(possibleElementName, localName)) {
                            similarElementNames.add(possibleElementName);
                            continue;
                        }
                        otherElementNames.add(possibleElementName);
                    }
                    boolean selectLocalNameOnly = element.getPrefix() != null;
                    ArrayList<Range> ranges = new ArrayList<Range>();
                    if (selectLocalNameOnly) {
                        startRange = XMLPositionUtility.selectStartTagLocalName(element);
                        endRange = XMLPositionUtility.selectEndTagLocalName(element);
                    } else {
                        startRange = XMLPositionUtility.selectStartTagName(element);
                        endRange = XMLPositionUtility.selectEndTagName(element);
                    }
                    ranges.add(startRange);
                    if (endRange != null) {
                        ranges.add(endRange);
                    }
                    if (!similarElementNames.isEmpty()) {
                        for (String string : similarElementNames) {
                            CodeAction similarCodeAction = CodeActionFactory.replaceAt("Did you mean '" + string + "'?", string, document.getTextDocument(), diagnostic, ranges);
                            codeActions.add(similarCodeAction);
                        }
                    } else {
                        for (String string : otherElementNames) {
                            CodeAction otherCodeAction = CodeActionFactory.replaceAt("Replace with '" + string + "'", string, document.getTextDocument(), diagnostic, ranges);
                            codeActions.add(otherCodeAction);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Collection<CMElementDeclaration> getPossibleElements(DOMElement element, IComponentProvider componentProvider) throws Exception {
        ContentModelManager contentModelManager = (ContentModelManager)componentProvider.getComponent(ContentModelManager.class);
        String prefix = element.getPrefix();
        DOMElement parentElement = element.getParentElement();
        String parentPrefix = parentElement.getPrefix();
        if (prefix != null && !prefix.equals(parentPrefix)) {
            String namespaceURI = element.getNamespaceURI();
            ArrayList<CMElementDeclaration> possibleElements = new ArrayList<CMElementDeclaration>();
            for (CMDocument cmDocument : contentModelManager.findCMDocument(parentElement, namespaceURI)) {
                possibleElements.addAll(cmDocument.getElements());
            }
            return possibleElements;
        }
        ArrayList<CMElementDeclaration> possibleElements = new ArrayList<CMElementDeclaration>();
        for (CMDocument cmDocument : contentModelManager.findCMDocument(parentElement)) {
            CMElementDeclaration cmElement = cmDocument.findCMElement(parentElement);
            if (cmElement == null) continue;
            possibleElements.addAll(cmElement.getPossibleElements(parentElement, element.getStart()));
        }
        return possibleElements;
    }

    private static boolean isSimilar(String reference, String current) {
        int threshold = Math.round(0.4f * (float)reference.length());
        LevenshteinDistance levenshteinDistance = new LevenshteinDistance(threshold);
        return levenshteinDistance.apply(reference, current) != -1;
    }
}

