/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMCDATASection;
import org.eclipse.lemminx.dom.DOMComment;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.dom.DOMProcessingInstruction;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.dom.DTDAttlistDecl;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.utils.XMLBuilder;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

class XMLFormatter {
    private static final Logger LOGGER = Logger.getLogger(XMLFormatter.class.getName());
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLFormatter(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public List<? extends TextEdit> format(TextDocument textDocument, Range range, XMLFormattingOptions formattingOptions) {
        try {
            XMLFormatterDocument formatterDocument = new XMLFormatterDocument(textDocument, range, formattingOptions);
            return formatterDocument.format();
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Formatting failed due to BadLocation", e);
            return null;
        }
    }

    private static class XMLFormatterDocument {
        private final TextDocument textDocument;
        private final Range range;
        private final XMLFormattingOptions options;
        private int startOffset;
        private int endOffset;
        private DOMDocument fullDomDocument;
        private DOMDocument rangeDomDocument;
        private XMLBuilder xmlBuilder;
        private int indentLevel;

        public XMLFormatterDocument(TextDocument textDocument, Range range, XMLFormattingOptions options) {
            this.textDocument = textDocument;
            this.range = range;
            this.options = options;
        }

        public List<? extends TextEdit> format() throws BadLocationException {
            this.fullDomDocument = DOMParser.getInstance().parse(this.textDocument.getText(), this.textDocument.getUri(), null, false);
            if (this.range != null) {
                this.setupRangeFormatting(this.range);
            } else {
                this.setupFullFormatting(this.range);
            }
            this.indentLevel = this.getStartingIndentLevel();
            this.format(this.rangeDomDocument);
            List<? extends TextEdit> textEdits = this.getFormatTextEdit();
            return textEdits;
        }

        private void setupRangeFormatting(Range range) throws BadLocationException {
            int startOffset = this.textDocument.offsetAt(range.getStart());
            int endOffset = this.textDocument.offsetAt(range.getEnd());
            Position startPosition = this.textDocument.positionAt(startOffset);
            Position endPosition = this.textDocument.positionAt(endOffset);
            this.enlargePositionToGutters(startPosition, endPosition);
            this.startOffset = this.textDocument.offsetAt(startPosition);
            this.endOffset = this.textDocument.offsetAt(endPosition);
            String fullText = this.textDocument.getText();
            String rangeText = fullText.substring(this.startOffset, this.endOffset);
            this.rangeDomDocument = DOMParser.getInstance().parse(rangeText, this.textDocument.getUri(), null, false);
            if (this.containsTextWithinStartTag()) {
                this.adjustOffsetToStartTag();
                rangeText = fullText.substring(this.startOffset, this.endOffset);
                this.rangeDomDocument = DOMParser.getInstance().parse(rangeText, this.textDocument.getUri(), null, false);
            }
            this.xmlBuilder = new XMLBuilder(this.options, "", this.textDocument.lineDelimiter(startPosition.getLine()));
        }

        private boolean containsTextWithinStartTag() {
            if (this.rangeDomDocument.getChildren().size() < 1) {
                return false;
            }
            DOMNode firstChild = this.rangeDomDocument.getChild(0);
            if (!firstChild.isText()) {
                return false;
            }
            int tagContentOffset = firstChild.getStart();
            int fullDocOffset = this.getFullOffsetFromRangeOffset(tagContentOffset);
            DOMNode fullNode = this.fullDomDocument.findNodeAt(fullDocOffset);
            if (!fullNode.isElement()) {
                return false;
            }
            return ((DOMElement)fullNode).isInStartTag(fullDocOffset);
        }

        private void adjustOffsetToStartTag() throws BadLocationException {
            int tagContentOffset = this.rangeDomDocument.getChild(0).getStart();
            int fullDocOffset = this.getFullOffsetFromRangeOffset(tagContentOffset);
            DOMNode fullNode = this.fullDomDocument.findNodeAt(fullDocOffset);
            Position nodePosition = this.textDocument.positionAt(fullNode.getStart());
            nodePosition.setCharacter(0);
            this.startOffset = this.textDocument.offsetAt(nodePosition);
        }

        private void setupFullFormatting(Range range) throws BadLocationException {
            this.startOffset = 0;
            this.endOffset = this.textDocument.getText().length();
            this.rangeDomDocument = this.fullDomDocument;
            Position startPosition = this.textDocument.positionAt(this.startOffset);
            this.xmlBuilder = new XMLBuilder(this.options, "", this.textDocument.lineDelimiter(startPosition.getLine()));
        }

        private void enlargePositionToGutters(Position start, Position end) throws BadLocationException {
            start.setCharacter(0);
            if (end.getCharacter() == 0 && end.getLine() > 0) {
                end.setLine(end.getLine() - 1);
            }
            end.setCharacter(this.textDocument.lineText(end.getLine()).length());
        }

        private int getStartingIndentLevel() throws BadLocationException {
            DOMNode startNode = this.fullDomDocument.findNodeAt(this.startOffset);
            if (startNode.isOwnerDocument()) {
                return 0;
            }
            DOMNode startNodeParent = startNode.getParentNode();
            if (startNodeParent.isOwnerDocument()) {
                return 0;
            }
            int startNodeIndentLevel = this.getNodeIndentLevel(startNodeParent) + 1;
            return startNodeIndentLevel;
        }

        private int getNodeIndentLevel(DOMNode node) throws BadLocationException {
            Position nodePosition = this.textDocument.positionAt(node.getStart());
            String textBeforeNode = this.textDocument.lineText(nodePosition.getLine()).substring(0, nodePosition.getCharacter() + 1);
            int spaceOrTab = this.getSpaceOrTabStartOfString(textBeforeNode);
            if (this.options.isInsertSpaces()) {
                return spaceOrTab / this.options.getTabSize();
            }
            return spaceOrTab;
        }

        private int getSpaceOrTabStartOfString(String string) {
            int spaceOrTab = 0;
            for (int i = 0; i < string.length() && (string.charAt(i) == ' ' || string.charAt(i) == '\t'); ++i) {
                ++spaceOrTab;
            }
            return spaceOrTab;
        }

        private int getFullOffsetFromRangeOffset(int rangeOffset) {
            return rangeOffset + this.startOffset;
        }

        private DOMElement getFullDocElemFromRangeElem(DOMElement elemFromRangeDoc) {
            int fullOffset = -1;
            if (elemFromRangeDoc.hasStartTag()) {
                fullOffset = this.getFullOffsetFromRangeOffset(elemFromRangeDoc.getStartTagOpenOffset()) + 1;
            } else if (elemFromRangeDoc.hasEndTag()) {
                fullOffset = this.getFullOffsetFromRangeOffset(elemFromRangeDoc.getEndTagCloseOffset()) - 1;
            } else {
                return null;
            }
            DOMElement elemFromFullDoc = (DOMElement)this.fullDomDocument.findNodeAt(fullOffset);
            return elemFromFullDoc;
        }

        private boolean startTagExistsInRangeDocument(DOMNode node) {
            if (!node.isElement()) {
                return false;
            }
            return ((DOMElement)node).hasStartTag();
        }

        private boolean startTagExistsInFullDocument(DOMNode node) {
            if (!node.isElement()) {
                return false;
            }
            DOMElement elemFromFullDoc = this.getFullDocElemFromRangeElem((DOMElement)node);
            if (elemFromFullDoc == null) {
                return false;
            }
            return elemFromFullDoc.hasStartTag();
        }

        private void format(DOMNode node) throws BadLocationException {
            if (node.getNodeType() != 9) {
                boolean doLineFeed;
                if (node.getOwnerDocument().isDTD()) {
                    doLineFeed = false;
                } else {
                    boolean bl = doLineFeed = (!node.isComment() || !((DOMComment)node).isCommentSameLineEndTag()) && (!node.isText() || !((DOMText)node).isWhitespace() && ((DOMText)node).hasSiblings());
                }
                if (this.indentLevel > 0 && doLineFeed) {
                    if (!node.isChildOfOwnerDocument() || node.getPreviousNonTextSibling() != null) {
                        this.xmlBuilder.linefeed();
                    }
                    if (!this.startTagExistsInRangeDocument(node) && this.startTagExistsInFullDocument(node)) {
                        DOMElement startNode = this.getFullDocElemFromRangeElem((DOMElement)node);
                        int currentIndentLevel = this.getNodeIndentLevel(startNode);
                        this.xmlBuilder.indent(currentIndentLevel);
                        this.indentLevel = currentIndentLevel;
                    } else {
                        this.xmlBuilder.indent(this.indentLevel);
                    }
                }
                if (node.isElement()) {
                    DOMElement element = (DOMElement)node;
                    String tag = element.getTagName();
                    if (element.hasEndTag() && !element.hasStartTag()) {
                        this.xmlBuilder.endElement(tag, element.isEndTagClosed());
                    } else {
                        this.xmlBuilder.startElement(tag, false);
                        if (element.hasAttributes()) {
                            List<DOMAttr> attributes = element.getAttributeNodes();
                            if (this.hasSingleAttributeInFullDoc(element)) {
                                DOMAttr singleAttribute = attributes.get(0);
                                this.xmlBuilder.addSingleAttribute(singleAttribute.getName(), singleAttribute.getOriginalValue());
                            } else {
                                for (DOMAttr attr : attributes) {
                                    this.xmlBuilder.addAttribute(attr, this.indentLevel);
                                }
                            }
                        }
                        if (element.isStartTagClosed()) {
                            this.xmlBuilder.closeStartElement();
                        }
                        boolean hasElements = false;
                        if (node.hasChildNodes()) {
                            ++this.indentLevel;
                            for (DOMNode child : node.getChildren()) {
                                boolean textElement = !child.isText();
                                hasElements |= textElement;
                                this.format(child);
                            }
                            --this.indentLevel;
                        }
                        if (element.hasEndTag()) {
                            if (hasElements) {
                                this.xmlBuilder.linefeed();
                                this.xmlBuilder.indent(this.indentLevel);
                            }
                            if (element.hasEndTag() && element.getEndTagOpenOffset() <= this.endOffset) {
                                this.xmlBuilder.endElement(tag, element.isEndTagClosed());
                            } else {
                                this.xmlBuilder.selfCloseElement();
                            }
                        } else if (element.isSelfClosed()) {
                            this.xmlBuilder.selfCloseElement();
                        }
                    }
                    return;
                }
                if (node.isCDATA()) {
                    DOMCDATASection cdata = (DOMCDATASection)node;
                    this.xmlBuilder.startCDATA();
                    this.xmlBuilder.addContentCDATA(cdata.getData());
                    this.xmlBuilder.endCDATA();
                } else if (node.isComment()) {
                    DOMComment comment = (DOMComment)node;
                    this.xmlBuilder.startComment(comment);
                    this.xmlBuilder.addContentComment(comment.getData());
                    this.xmlBuilder.endComment();
                    if (this.indentLevel == 0) {
                        this.xmlBuilder.linefeed();
                    }
                } else if (node.isProcessingInstruction()) {
                    XMLFormatterDocument.addPIToXMLBuilder(node, this.xmlBuilder);
                    if (this.indentLevel == 0) {
                        this.xmlBuilder.linefeed();
                    }
                } else if (node.isProlog()) {
                    XMLFormatterDocument.addPrologToXMLBuilder(node, this.xmlBuilder);
                    this.xmlBuilder.linefeed();
                } else {
                    if (node.isText()) {
                        DOMText textNode = (DOMText)node;
                        String content = textNode.getData();
                        this.xmlBuilder.addContent(content, textNode.isWhitespace(), textNode.hasSiblings(), textNode.getDelimiter(), this.indentLevel);
                        return;
                    }
                    if (node.isDoctype()) {
                        boolean isDTD = node.getOwnerDocument().isDTD();
                        DOMDocumentType documentType = (DOMDocumentType)node;
                        if (!isDTD) {
                            this.xmlBuilder.startDoctype();
                            List<DTDDeclParameter> params = documentType.getParameters();
                            for (DTDDeclParameter param : params) {
                                if (!documentType.isInternalSubset(param)) {
                                    this.xmlBuilder.addParameter(param.getParameter());
                                    continue;
                                }
                                this.xmlBuilder.startDoctypeInternalSubset();
                                this.xmlBuilder.linefeed();
                                XMLFormatterDocument.formatDTD(documentType, this.indentLevel + 1, this.endOffset, this.xmlBuilder);
                                this.xmlBuilder.linefeed();
                                this.xmlBuilder.endDoctypeInternalSubset();
                            }
                            if (documentType.isClosed()) {
                                this.xmlBuilder.endDoctype();
                            }
                            this.xmlBuilder.linefeed();
                        } else {
                            XMLFormatterDocument.formatDTD(documentType, 0, this.endOffset, this.xmlBuilder);
                        }
                        return;
                    }
                }
            } else if (node.hasChildNodes()) {
                for (DOMNode child : node.getChildren()) {
                    this.format(child);
                }
            }
        }

        private static boolean formatDTD(DOMDocumentType doctype, int level, int end, XMLBuilder xmlBuilder) {
            DOMNode previous = null;
            for (DOMNode node : doctype.getChildren()) {
                if (previous != null) {
                    xmlBuilder.linefeed();
                }
                xmlBuilder.indent(level);
                if (node.isText()) {
                    xmlBuilder.addContent(((DOMText)node).getData().trim());
                } else if (node.isComment()) {
                    DOMComment comment = (DOMComment)node;
                    xmlBuilder.startComment(comment);
                    xmlBuilder.addContentComment(comment.getData());
                    xmlBuilder.endComment();
                } else if (node.isProcessingInstruction()) {
                    XMLFormatterDocument.addPIToXMLBuilder(node, xmlBuilder);
                } else if (node.isProlog()) {
                    XMLFormatterDocument.addPrologToXMLBuilder(node, xmlBuilder);
                } else {
                    boolean setEndBracketOnNewLine = false;
                    DTDDeclNode decl = (DTDDeclNode)node;
                    xmlBuilder.addDeclTagStart(decl);
                    if (decl.isDTDAttListDecl()) {
                        DTDAttlistDecl attlist = (DTDAttlistDecl)decl;
                        List<DTDAttlistDecl> internalDecls = attlist.getInternalChildren();
                        if (internalDecls == null) {
                            for (DTDDeclParameter param : decl.getParameters()) {
                                xmlBuilder.addParameter(param.getParameter());
                            }
                        } else {
                            DTDDeclParameter param;
                            boolean multipleInternalAttlistDecls = false;
                            List<DTDDeclParameter> params = attlist.getParameters();
                            for (int i = 0; i < params.size(); ++i) {
                                param = params.get(i);
                                if (attlist.getNameParameter().equals(param)) {
                                    xmlBuilder.addParameter(param.getParameter());
                                    if (attlist.getParameters().size() <= 1) continue;
                                    xmlBuilder.linefeed();
                                    xmlBuilder.indent(level + 1);
                                    setEndBracketOnNewLine = true;
                                    multipleInternalAttlistDecls = true;
                                    continue;
                                }
                                if (multipleInternalAttlistDecls && i == 1) {
                                    xmlBuilder.addUnindentedParameter(param.getParameter());
                                    continue;
                                }
                                xmlBuilder.addParameter(param.getParameter());
                            }
                            for (DTDAttlistDecl attlistDecl : internalDecls) {
                                xmlBuilder.linefeed();
                                xmlBuilder.indent(level + 1);
                                params = attlistDecl.getParameters();
                                for (int i = 0; i < params.size(); ++i) {
                                    param = params.get(i);
                                    if (i == 0) {
                                        xmlBuilder.addUnindentedParameter(param.getParameter());
                                        continue;
                                    }
                                    xmlBuilder.addParameter(param.getParameter());
                                }
                            }
                        }
                    } else {
                        for (DTDDeclParameter param : decl.getParameters()) {
                            xmlBuilder.addParameter(param.getParameter());
                        }
                    }
                    if (setEndBracketOnNewLine) {
                        xmlBuilder.linefeed();
                        xmlBuilder.indent(level);
                    }
                    if (decl.isClosed()) {
                        xmlBuilder.closeStartElement();
                    }
                }
                previous = node;
            }
            return true;
        }

        private boolean hasSingleAttributeInFullDoc(DOMElement element) {
            DOMElement fullElement = this.getFullDocElemFromRangeElem(element);
            return fullElement.getAttributeNodes().size() == 1;
        }

        private List<? extends TextEdit> getFormatTextEdit() throws BadLocationException {
            Position startPosition = this.textDocument.positionAt(this.startOffset);
            Position endPosition = this.textDocument.positionAt(this.endOffset);
            Range r = new Range(startPosition, endPosition);
            ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
            edits.add(new TextEdit(r, this.xmlBuilder.toString()));
            return edits;
        }

        private static void addPIToXMLBuilder(DOMNode node, XMLBuilder xml) {
            DOMProcessingInstruction processingInstruction = (DOMProcessingInstruction)node;
            xml.startPrologOrPI(processingInstruction.getTarget());
            String content = processingInstruction.getData();
            if (content.length() > 0) {
                xml.addContentPI(content);
            } else {
                xml.addContent(" ");
            }
            xml.endPrologOrPI();
        }

        private static void addPrologToXMLBuilder(DOMNode node, XMLBuilder xml) {
            DOMProcessingInstruction processingInstruction = (DOMProcessingInstruction)node;
            xml.startPrologOrPI(processingInstruction.getTarget());
            if (node.hasAttributes()) {
                XMLFormatterDocument.addAttributes(node, xml);
            }
            xml.endPrologOrPI();
        }

        private static void addAttributes(DOMNode node, XMLBuilder xmlBuilder) {
            List<DOMAttr> attrs = node.getAttributeNodes();
            if (attrs == null) {
                return;
            }
            for (DOMAttr attr : attrs) {
                xmlBuilder.addAttributesOnSingleLine(attr, true);
            }
            xmlBuilder.appendSpace();
        }
    }
}

