/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.lemminx.dom.DOMAttr;

public class SchemaLocation {
    private final Map<String, String> schemaLocationValuePairs;
    private final DOMAttr attr;

    public SchemaLocation(String base, DOMAttr attr) {
        this.attr = attr;
        this.schemaLocationValuePairs = new HashMap<String, String>();
        String value = attr.getValue();
        StringTokenizer st = new StringTokenizer(value);
        while (true) {
            String locationHint;
            String namespaceURI = st.hasMoreTokens() ? st.nextToken() : null;
            String string = locationHint = st.hasMoreTokens() ? st.nextToken() : null;
            if (namespaceURI == null || locationHint == null) break;
            this.schemaLocationValuePairs.put(namespaceURI, locationHint);
        }
    }

    public String getLocationHint(String namespaceURI) {
        return this.schemaLocationValuePairs.get(namespaceURI);
    }

    public DOMAttr getAttr() {
        return this.attr;
    }
}

