/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.asset.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.kura.asset.AssetConfiguration;
import org.eclipse.kura.asset.provider.AssetConstants;
import org.eclipse.kura.channel.Channel;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.channel.ChannelType;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.configuration.metatype.OCD;
import org.eclipse.kura.configuration.metatype.Option;
import org.eclipse.kura.core.configuration.metatype.Tad;
import org.eclipse.kura.core.configuration.metatype.Tocd;
import org.eclipse.kura.core.configuration.metatype.Toption;
import org.eclipse.kura.core.configuration.metatype.Tscalar;
import org.eclipse.kura.core.configuration.util.ComponentUtil;
import org.eclipse.kura.driver.ChannelDescriptor;
import org.eclipse.kura.driver.Driver;
import org.eclipse.kura.type.DataType;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BaseAssetConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(BaseAssetConfiguration.class);
    private Map<String, Object> properties;
    private Tocd ocd;
    private AssetConfiguration assetConfiguration;
    private final boolean hasReadChannels;
    private final String kuraServicePid;

    public BaseAssetConfiguration(Tocd baseOcd, ComponentContext context, Map<String, Object> properties) {
        this.properties = BaseAssetConfiguration.fillOcdDefaults(properties, baseOcd, context);
        this.assetConfiguration = new AssetConfiguration(BaseAssetConfiguration.getDescription(properties), BaseAssetConfiguration.getDriverPid(properties), BaseAssetConfiguration.retreiveChannelList(properties));
        this.hasReadChannels = !this.getAllReadRecords().isEmpty();
        this.kuraServicePid = (String)properties.get("kura.service.pid");
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Tocd getDefinition() {
        return this.ocd;
    }

    public AssetConfiguration getAssetConfiguration() {
        return this.assetConfiguration;
    }

    public boolean hasReadChannels() {
        return this.hasReadChannels;
    }

    public String getKuraServicePid() {
        return this.kuraServicePid;
    }

    public List<ChannelRecord> getAllReadRecords() {
        Map channels = this.getAssetConfiguration().getAssetChannels();
        ArrayList<ChannelRecord> readRecords = new ArrayList<ChannelRecord>();
        for (Map.Entry e : channels.entrySet()) {
            Channel channel = (Channel)e.getValue();
            if (!channel.isEnabled() || channel.getType() != ChannelType.READ && channel.getType() != ChannelType.READ_WRITE) continue;
            readRecords.add(channel.createReadRecord());
        }
        return Collections.unmodifiableList(readRecords);
    }

    public void complete(Tocd baseOcd, ComponentContext context, List<Tad> assetDescriptor, Driver driver) {
        List driverDescriptor;
        try {
            ChannelDescriptor channelDescriptor = driver.getChannelDescriptor();
            if (channelDescriptor == null) {
                return;
            }
            Object opaqueDriverDescriptor = channelDescriptor.getDescriptor();
            if (!(opaqueDriverDescriptor instanceof List)) {
                return;
            }
            driverDescriptor = (List)opaqueDriverDescriptor;
        }
        catch (Exception e) {
            logger.warn("Failed to get channel descriptor", (Throwable)e);
            return;
        }
        logger.info("updating asset configuration...");
        long start = System.currentTimeMillis();
        Map<String, Object> updatedConfiguration = this.updateConfiguration(context, assetDescriptor, new HashMap<String, Object>(this.properties), driverDescriptor);
        logger.info("updating asset configuration...done in {} ms", (Object)(System.currentTimeMillis() - start));
        if (updatedConfiguration != null) {
            this.properties = updatedConfiguration;
            this.assetConfiguration = new AssetConfiguration(BaseAssetConfiguration.getDescription(this.properties), BaseAssetConfiguration.getDriverPid(this.properties), BaseAssetConfiguration.retreiveChannelList(this.properties));
        }
        this.ocd = this.buildDefinition(baseOcd, assetDescriptor, driverDescriptor);
    }

    private Tocd buildDefinition(Tocd baseOcd, List<Tad> assetDescriptor, List<Tad> driverDescriptor) {
        Stream.concat(assetDescriptor.stream(), driverDescriptor.stream()).forEach(attribute -> {
            for (Map.Entry entry : this.assetConfiguration.getAssetChannels().entrySet()) {
                String channelName = (String)entry.getKey();
                if (!(attribute instanceof Tad)) {
                    return;
                }
                Tad newAttribute = BaseAssetConfiguration.cloneAd(attribute, channelName);
                baseOcd.addAD(newAttribute);
            }
        });
        return baseOcd;
    }

    private Map<String, Object> updateConfiguration(ComponentContext context, List<Tad> assetDescriptor, Map<String, Object> properties, List<Tad> driverDescriptor) {
        HashMap<String, Object> newConfiguration = null;
        Tocd tempOcd = new Tocd();
        assetDescriptor.forEach(arg_0 -> ((Tocd)tempOcd).addAD(arg_0));
        driverDescriptor.forEach(arg_0 -> ((Tocd)tempOcd).addAD(arg_0));
        Map defaultValues = ComponentUtil.getDefaultProperties((OCD)tempOcd, (ComponentContext)context);
        Map channels = this.assetConfiguration.getAssetChannels();
        for (AD tad : tempOcd.getAD()) {
            if (!tad.isRequired()) continue;
            String id = tad.getId();
            for (Channel channel : channels.values()) {
                Map config = channel.getConfiguration();
                if (config.get(id) != null) continue;
                if (newConfiguration == null) {
                    newConfiguration = new HashMap<String, Object>(properties);
                }
                Object defaultValue = defaultValues.get(id);
                newConfiguration.put(String.valueOf(channel.getName()) + AssetConstants.CHANNEL_PROPERTY_SEPARATOR.value() + id, defaultValue);
            }
        }
        return newConfiguration;
    }

    private static Tad cloneAd(Tad oldAd, String channelName) {
        String oldAdId = oldAd.getId();
        String prefix = String.valueOf(channelName) + AssetConstants.CHANNEL_PROPERTY_SEPARATOR.value();
        Tad result = new Tad();
        result.setId(String.valueOf(prefix) + oldAdId);
        result.setName(String.valueOf(prefix) + oldAd.getName());
        result.setCardinality(Integer.valueOf(oldAd.getCardinality()));
        result.setType(Tscalar.fromValue((String)oldAd.getType().value()));
        result.setDescription(oldAd.getDescription());
        result.setDefault(oldAd.getDefault());
        result.setMax(oldAd.getMax());
        result.setMin(oldAd.getMin());
        result.setRequired(Boolean.valueOf(oldAd.isRequired()));
        for (Option option : oldAd.getOption()) {
            Toption newOption = new Toption();
            newOption.setLabel(option.getLabel());
            newOption.setValue(option.getValue());
            result.getOption().add(newOption);
        }
        return result;
    }

    private static String getDescription(Map<String, Object> properties) {
        return (String)properties.getOrDefault(AssetConstants.ASSET_DESC_PROP.value(), "");
    }

    private static String getDriverPid(Map<String, Object> properties) {
        return (String)properties.get(AssetConstants.ASSET_DRIVER_PROP.value());
    }

    private static Map<String, Channel> retreiveChannelList(Map<String, Object> properties) {
        ChannelParser parser = new ChannelParser();
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            ChannelProperty property = ChannelProperty.parse(e.getKey());
            if (property == null) continue;
            Object value = e.getValue();
            parser.process(property, value != null ? value.toString() : null);
        }
        return parser.getChannelList();
    }

    private static Map<String, Object> fillOcdDefaults(Map<String, Object> properties, Tocd ocd, ComponentContext context) {
        Map defaultProperties = ComponentUtil.getDefaultProperties((OCD)ocd, (ComponentContext)context);
        defaultProperties.putAll(properties);
        return defaultProperties;
    }

    private static final class ChannelParser {
        final Map<String, Map<String, Object>> channels = new HashMap<String, Map<String, Object>>();

        private ChannelParser() {
        }

        private Map<String, Object> getChannelProperties(String channelName) {
            return this.channels.computeIfAbsent(channelName, k -> new HashMap());
        }

        void process(ChannelProperty property, Object value) {
            this.getChannelProperties(property.channelName).put(property.propertyName, value);
        }

        final Map<String, Channel> getChannelList() {
            return this.channels.entrySet().parallelStream().map(e -> ChannelParser.extractChannel((String)e.getKey(), (Map)e.getValue())).filter(Objects::nonNull).collect(Collectors.toMap(Channel::getName, c -> c));
        }

        private static ChannelType getChannelType(Map<String, Object> properties) {
            String channelTypeProp = (String)properties.get(AssetConstants.TYPE.value());
            if (channelTypeProp == null) {
                return null;
            }
            return ChannelType.getChannelType((String)channelTypeProp);
        }

        private static DataType getDataType(Map<String, Object> properties) {
            String valueTypeProp = (String)properties.get(AssetConstants.VALUE_TYPE.value());
            if (valueTypeProp == null) {
                return null;
            }
            return DataType.getDataType((String)valueTypeProp);
        }

        private static boolean isEnabled(Map<String, Object> properties) {
            try {
                return Boolean.parseBoolean(properties.get(AssetConstants.ENABLED.value()).toString());
            }
            catch (Exception exception) {
                logger.debug("Failed to retrieve enabled channel property");
                return true;
            }
        }

        private static Channel extractChannel(String channelName, Map<String, Object> channelConfig) {
            logger.debug("Retrieving single channel information from the properties...");
            ChannelType channelType = ChannelParser.getChannelType(channelConfig);
            if (channelType == null) {
                return null;
            }
            DataType dataType = ChannelParser.getDataType(channelConfig);
            if (dataType == null) {
                return null;
            }
            boolean isEnabled = ChannelParser.isEnabled(channelConfig);
            Channel channel = new Channel(channelName, channelType, dataType, channelConfig);
            channel.setEnabled(isEnabled);
            logger.debug("Retrieving single channel information from the properties...Done");
            return channel;
        }
    }

    private static final class ChannelProperty {
        final String channelName;
        final String propertyName;

        ChannelProperty(String channelName, String propertyName) {
            this.channelName = channelName;
            this.propertyName = propertyName;
        }

        private static boolean isValidChannelName(String channelName) {
            if (Objects.isNull(channelName)) {
                return false;
            }
            String prohibitedChars = AssetConstants.CHANNEL_NAME_PROHIBITED_CHARS.value();
            int i = 0;
            while (i < channelName.length()) {
                if (prohibitedChars.indexOf(channelName.charAt(i)) != -1) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        static ChannelProperty parse(String propertyKey) {
            int pos = propertyKey.indexOf(AssetConstants.CHANNEL_PROPERTY_SEPARATOR.value());
            if (pos <= 0 || pos >= propertyKey.length() - 1) {
                return null;
            }
            String channelName = propertyKey.substring(0, pos);
            if (!ChannelProperty.isValidChannelName(channelName)) {
                return null;
            }
            String propertyName = propertyKey.substring(pos + 1);
            return new ChannelProperty(channelName, propertyName);
        }
    }
}

