/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.linux.bluetooth.le;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.bluetooth.BluetoothBeaconData;
import org.eclipse.kura.bluetooth.BluetoothBeaconScanListener;
import org.eclipse.kura.bluetooth.BluetoothDevice;
import org.eclipse.kura.bluetooth.BluetoothLeScanListener;
import org.eclipse.kura.bluetooth.listener.BluetoothAdvertisementData;
import org.eclipse.kura.bluetooth.listener.BluetoothAdvertisementScanListener;
import org.eclipse.kura.core.linux.executor.LinuxSignal;
import org.eclipse.kura.executor.CommandExecutorService;
import org.eclipse.kura.executor.Signal;
import org.eclipse.kura.linux.bluetooth.BluetoothDeviceImpl;
import org.eclipse.kura.linux.bluetooth.util.BTSnoopListener;
import org.eclipse.kura.linux.bluetooth.util.BluetoothProcess;
import org.eclipse.kura.linux.bluetooth.util.BluetoothProcessListener;
import org.eclipse.kura.linux.bluetooth.util.BluetoothUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothLeScanner
implements BluetoothProcessListener,
BTSnoopListener {
    private static final Logger logger = LoggerFactory.getLogger(BluetoothLeScanner.class);
    private static final String MAC_REGEX = "^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$";
    public static final int SCAN_FAILED_INTERNAL_ERROR = 3;
    private final Map<String, String> devices = new HashMap<String, String>();
    private List<BluetoothDevice> scanResult;
    private BluetoothProcess proc = null;
    private BluetoothProcess dumpProc = null;
    private BluetoothLeScanListener listener = null;
    private BluetoothBeaconScanListener beaconListener = null;
    private BluetoothAdvertisementScanListener advertisementListener = null;
    private boolean scanRunning = false;
    private String companyName;
    private final CommandExecutorService executorService;

    public BluetoothLeScanner(CommandExecutorService executorService) {
        this.executorService = executorService;
    }

    public void startScan(String name, BluetoothLeScanListener listener) {
        this.listener = listener;
        logger.info("Starting bluetooth le scan...");
        try {
            this.proc = BluetoothUtil.hcitoolCmd(name, "lescan", (BluetoothProcessListener)this, this.executorService);
            this.setScanRunning(true);
        }
        catch (IOException e) {
            logger.error("Failed to start device scan", (Throwable)e);
        }
    }

    public void startAdvertisementScan(String name, String companyName, BluetoothAdvertisementScanListener listener) {
        this.advertisementListener = listener;
        this.companyName = companyName;
        logger.info("Starting bluetooth le advertisement scan...");
        try {
            this.proc = BluetoothUtil.hcitoolCmd(name, new String[]{"lescan-passive", "--duplicates"}, (BluetoothProcessListener)this, this.executorService);
            this.dumpProc = BluetoothUtil.btdumpCmd(name, this, this.executorService);
            this.setScanRunning(true);
        }
        catch (IOException e) {
            logger.error("Failed to start advertisement scan", (Throwable)e);
        }
    }

    public void startBeaconScan(String name, String companyName, BluetoothBeaconScanListener listener) {
        this.beaconListener = listener;
        this.companyName = companyName;
        logger.info("Starting bluetooth le beacon scan...");
        try {
            this.proc = BluetoothUtil.hcitoolCmd(name, new String[]{"lescan-passive", "--duplicates"}, (BluetoothProcessListener)this, this.executorService);
            this.dumpProc = BluetoothUtil.btdumpCmd(name, this, this.executorService);
            this.setScanRunning(true);
        }
        catch (IOException e) {
            logger.error("Failed to start beacon scan", (Throwable)e);
        }
    }

    public void killScan(String name) {
        if (this.proc != null) {
            logger.info("Killing hcitool...");
            if (!BluetoothUtil.stopHcitool(name, this.executorService, "")) {
                logger.info("Cannot kill hcitool process...");
            }
            this.proc.destroy();
        } else {
            logger.info("Cannot destroy hcitool process...");
        }
        if (this.dumpProc != null) {
            logger.info("Killing btdump...");
            BluetoothUtil.stopBtdump(name, this.executorService);
            BluetoothUtil.killCmd(new String[]{"hcidump", "-i", name}, (Signal)LinuxSignal.SIGINT, this.executorService);
            this.dumpProc.destroyBTSnoop();
        } else {
            logger.info("Cannot destroy btdump process...");
        }
        this.setScanRunning(false);
    }

    @Override
    public void processInputStream(String string) {
        if (this.listener != null) {
            String[] lines;
            String[] stringArray = lines = string.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.processLine(line);
                ++n2;
            }
            this.scanResult = new ArrayList<BluetoothDevice>();
            for (Map.Entry<String, String> device : this.devices.entrySet()) {
                this.scanResult.add(new BluetoothDeviceImpl(device.getKey(), device.getValue(), this.executorService));
                logger.info("scanResult.add {} - {}", (Object)device.getKey(), (Object)device.getValue());
            }
            this.listener.onScanResults(this.scanResult);
        }
    }

    @Override
    public void processInputStream(int ch) {
    }

    @Override
    public void processBTSnoopRecord(byte[] record) {
        try {
            BluetoothAdvertisementData bAdData = BluetoothUtil.parseLEAdvertisement(record);
            if (bAdData != null && this.advertisementListener != null) {
                try {
                    this.advertisementListener.onAdvertisementDataReceived(bAdData);
                }
                catch (Exception e) {
                    logger.error("Scan listener threw exception", (Throwable)e);
                }
            }
            List<BluetoothBeaconData> beaconDatas = BluetoothUtil.parseLEAdvertisingReport(record, this.companyName);
            for (BluetoothBeaconData beaconData : beaconDatas) {
                try {
                    if (this.beaconListener == null) continue;
                    this.beaconListener.onBeaconDataReceived(beaconData);
                }
                catch (Exception e) {
                    logger.error("Scan listener threw exception", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error processing advertising report", (Throwable)e);
        }
    }

    @Override
    public void processErrorStream(String string) {
    }

    private void processLine(String line) {
        logger.info(line);
        if (line.contains("Set scan parameters failed:")) {
            logger.error("Error : {}", (Object)line);
        } else {
            String[] results = line.split("\\s", 2);
            if (results.length == 2) {
                String address = results[0].trim();
                String name = results[1].trim();
                if (address.matches(MAC_REGEX)) {
                    if (this.devices.containsKey(address)) {
                        if (!name.equals("(unknown)") && !this.devices.get(address).equals(name)) {
                            logger.debug("Updating device: {} - {}", (Object)address, (Object)name);
                            this.devices.put(address, name);
                        }
                    } else {
                        logger.debug("Device found: {} - {}", (Object)address, (Object)name);
                        this.devices.put(address, name);
                    }
                }
            }
        }
    }

    public boolean isScanRunning() {
        return this.scanRunning;
    }

    private void setScanRunning(boolean scanRunning) {
        this.scanRunning = scanRunning;
    }

    @Deprecated
    public boolean is_scanRunning() {
        return this.scanRunning;
    }

    @Deprecated
    public void set_scanRunning(boolean scanRunning) {
        this.scanRunning = scanRunning;
    }
}

