/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.audit.AuditConstants;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.publisher.CloudNotificationPublisher;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerContext;
import org.eclipse.kura.cloudconnection.request.RequestHandlerContextConstants;
import org.eclipse.kura.cloudconnection.request.RequestHandlerMessageConstants;
import org.eclipse.kura.data.DataService;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.CloudConnectionManagerImpl;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.CloudConnectionManagerOptions;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.message.MessageType;
import org.eclipse.kura.message.KuraPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandlerCallable
implements Callable<Void> {
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");
    private static final Logger logger = LoggerFactory.getLogger(MessageHandlerCallable.class);
    private static final Pattern RESOURCES_DELIM = Pattern.compile("/");
    public static final String METRIC_REQUEST_ID = "request.id";
    public static final String REQUESTER_CLIENT_ID = "requester.client.id";
    public static final String METRIC_RESPONSE_CODE = "response.code";
    public static final String METRIC_EXCEPTION_MSG = "response.exception.message";
    public static final String METRIC_EXCEPTION_STACK = "response.exception.stack";
    public static final int RESPONSE_CODE_OK = 200;
    public static final int RESPONSE_CODE_BAD_REQUEST = 400;
    public static final int RESPONSE_CODE_NOTFOUND = 404;
    public static final int RESPONSE_CODE_ERROR = 500;
    protected static final int DFLT_PUB_QOS = 0;
    protected static final boolean DFLT_RETAIN = false;
    protected static final int DFLT_PRIORITY = 1;
    private final RequestHandler cloudApp;
    private final String appTopic;
    private final KuraPayload kuraMessage;
    private final CloudConnectionManagerImpl cloudConnectionManager;
    private final RequestHandlerContext requestHandlerContext;

    public MessageHandlerCallable(RequestHandler cloudApp, String appTopic, KuraPayload msg, CloudConnectionManagerImpl cloudConnectionManager) {
        this.cloudApp = cloudApp;
        this.appTopic = appTopic;
        this.kuraMessage = msg;
        this.cloudConnectionManager = cloudConnectionManager;
        Object notificationPublisherPid = null;
        CloudNotificationPublisher notificationPublisher = null;
        HashMap<String, Object> contextProperties = new HashMap<String, Object>();
        contextProperties.put(RequestHandlerContextConstants.NOTIFICATION_PUBLISHER_PID.name(), notificationPublisherPid);
        this.requestHandlerContext = new RequestHandlerContext(notificationPublisher, contextProperties);
    }

    @Override
    public Void call() throws Exception {
        logger.debug("Control Arrived on topic: {}", (Object)this.appTopic);
        String requestId = (String)this.kuraMessage.getMetric(METRIC_REQUEST_ID);
        if (requestId == null) {
            throw new ParseException("Not a valid request payload", 0);
        }
        KuraPayload reqPayload = this.kuraMessage;
        HashMap<String, String> auditProperties = new HashMap<String, String>();
        auditProperties.put(AuditConstants.KEY_ENTRY_POINT.getValue(), "EclipseIoTCloudConnectionService");
        auditProperties.put("cloud.app.topic", this.appTopic);
        auditProperties.put("cloud.connection.pid", this.cloudConnectionManager.getOwnPid());
        Throwable throwable = null;
        Object var6_6 = null;
        try (AuditContext.Scope scope = AuditContext.openScope((AuditContext)new AuditContext(auditProperties));){
            boolean isSuccessful;
            KuraMessage response;
            try {
                Iterator<String> resources = RESOURCES_DELIM.splitAsStream(this.appTopic).iterator();
                if (!resources.hasNext()) {
                    throw new IllegalArgumentException();
                }
                String method = (String)resources.next();
                Map<String, Object> reqResources = this.getMessageResources(resources);
                KuraMessage reqMessage = new KuraMessage(reqPayload, reqResources);
                switch (method) {
                    case "GET": {
                        logger.debug("Handling GET request topic: {}", (Object)this.appTopic);
                        response = this.cloudApp.doGet(this.requestHandlerContext, reqMessage);
                        break;
                    }
                    case "PUT": {
                        logger.debug("Handling PUT request topic: {}", (Object)this.appTopic);
                        response = this.cloudApp.doPut(this.requestHandlerContext, reqMessage);
                        break;
                    }
                    case "POST": {
                        logger.debug("Handling POST request topic: {}", (Object)this.appTopic);
                        response = this.cloudApp.doPost(this.requestHandlerContext, reqMessage);
                        break;
                    }
                    case "DEL": {
                        logger.debug("Handling DEL request topic: {}", (Object)this.appTopic);
                        response = this.cloudApp.doDel(this.requestHandlerContext, reqMessage);
                        break;
                    }
                    case "EXEC": {
                        logger.debug("Handling EXEC request topic: {}", (Object)this.appTopic);
                        response = this.cloudApp.doExec(this.requestHandlerContext, reqMessage);
                        break;
                    }
                    default: {
                        logger.error("Bad request topic: {}", (Object)this.appTopic);
                        KuraPayload payload = new KuraPayload();
                        response = this.setResponseCode(payload, 400);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error("Bad request topic: {}", (Object)this.appTopic);
                KuraPayload payload = new KuraPayload();
                response = this.setResponseCode(payload, 400);
            }
            catch (KuraException e) {
                logger.error("Error handling request topic: {}", (Object)this.appTopic, (Object)e);
                response = this.manageException(e);
            }
            Object responseCode = response.getPayload().getMetric(METRIC_RESPONSE_CODE);
            boolean bl = isSuccessful = responseCode instanceof Integer && (Integer)responseCode / 200 == 1;
            if (isSuccessful) {
                auditLogger.info("{} CloudCall - Success - Execute RequestHandler call", (Object)AuditContext.currentOrInternal());
            } else {
                auditLogger.warn("{} CloudCall - Failure - Execute RequestHandler call", (Object)AuditContext.currentOrInternal());
            }
            this.buildResponseMessage(requestId, response);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    private void buildResponseMessage(String requestId, KuraMessage response) {
        try {
            response.getPayload().setTimestamp(new Date());
            DataService dataService = this.cloudConnectionManager.getDataService();
            String fullTopic = this.encodeTopic(requestId, String.valueOf(response.getPayload().getMetric(METRIC_RESPONSE_CODE)));
            byte[] appPayload = this.cloudConnectionManager.encodePayload(response.getPayload());
            dataService.publish(fullTopic, appPayload, 0, false, 1);
        }
        catch (KuraException e) {
            logger.error("Error publishing response for topic: {}\n{}", (Object)this.appTopic, (Object)e);
        }
    }

    private KuraMessage manageException(KuraException e) {
        KuraPayload payload = new KuraPayload();
        this.setException(payload, e);
        KuraMessage message = e.getCode().equals((Object)KuraErrorCode.BAD_REQUEST) ? this.setResponseCode(payload, 400) : (e.getCode().equals((Object)KuraErrorCode.NOT_FOUND) ? this.setResponseCode(payload, 404) : this.setResponseCode(payload, 500));
        return message;
    }

    private Map<String, Object> getMessageResources(Iterator<String> iter) {
        ArrayList<String> resourcesList = new ArrayList<String>();
        while (iter.hasNext()) {
            resourcesList.add(iter.next());
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(RequestHandlerMessageConstants.ARGS_KEY.value(), resourcesList);
        return properties;
    }

    public KuraMessage setResponseCode(KuraPayload payload, int responseCode) {
        payload.addMetric(METRIC_RESPONSE_CODE, (Object)responseCode);
        return new KuraMessage(payload);
    }

    public void setException(KuraPayload payload, Throwable t) {
        if (t != null) {
            payload.addMetric(METRIC_EXCEPTION_MSG, (Object)t.getMessage());
            payload.addMetric(METRIC_EXCEPTION_STACK, (Object)this.stackTraceAsString(t));
        }
    }

    private String stackTraceAsString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    private String encodeTopic(String requestId, String responseCode) {
        CloudConnectionManagerOptions options = this.cloudConnectionManager.getCloudConnectionManagerOptions();
        String topicSeparator = options.getTopicSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append(MessageType.CONTROL.getTopicPrefix()).append(topicSeparator).append(topicSeparator).append(topicSeparator).append("res");
        sb.append(topicSeparator).append(requestId).append(topicSeparator).append(responseCode);
        return sb.toString();
    }
}

