/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.core.configuration.XmlComponentConfigurations;
import org.eclipse.kura.marshalling.Marshaller;
import org.eclipse.kura.util.service.ServiceUtil;
import org.eclipse.kura.web.server.KuraRemoteServiceServlet;
import org.eclipse.kura.web.server.servlet.AuditServlet;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceSnapshotsServlet
extends AuditServlet {
    private static final long serialVersionUID = -2533869595709953567L;
    private static Logger logger = LoggerFactory.getLogger(DeviceSnapshotsServlet.class);

    public DeviceSnapshotsServlet() {
        super("UI Snapshots", "Return device snapshot");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            GwtXSRFToken token = new GwtXSRFToken(request.getParameter("xsrfToken"));
            KuraRemoteServiceServlet.checkXSRFToken(request, token);
        }
        catch (Exception e) {
            throw new ServletException("Security error: please retry this operation correctly.", (Throwable)e);
        }
        String snapshotId = request.getParameter("snapshotId");
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (PrintWriter writer = response.getWriter();){
                ServiceLocator locator = ServiceLocator.getInstance();
                ConfigurationService cs = locator.getService(ConfigurationService.class);
                if (snapshotId != null) {
                    long sid = Long.parseLong(snapshotId);
                    List configs = cs.getSnapshot(sid);
                    ArrayList<ComponentConfiguration> configImpls = new ArrayList<ComponentConfiguration>();
                    for (ComponentConfiguration config : configs) {
                        configImpls.add(config);
                    }
                    XmlComponentConfigurations xmlConfigs = new XmlComponentConfigurations();
                    xmlConfigs.setConfigurations(configImpls);
                    String result = this.marshal(xmlConfigs);
                    response.setCharacterEncoding("UTF-8");
                    response.setContentType("application/xml");
                    response.setHeader("Content-Disposition", "attachment; filename=snapshot_" + sid + ".xml");
                    response.setHeader("Cache-Control", "no-transform, max-age=0");
                    writer.write(result);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error("Error exporting snapshot");
            throw new ServletException((Throwable)e);
        }
    }

    private ServiceReference<Marshaller>[] getXmlMarshallers() {
        String filterString = String.format("(&(kura.service.pid=%s))", "org.eclipse.kura.xml.marshaller.unmarshaller.provider");
        return ServiceUtil.getServiceReferences((BundleContext)FrameworkUtil.getBundle(DeviceSnapshotsServlet.class).getBundleContext(), Marshaller.class, (String)filterString);
    }

    private void ungetServiceReferences(ServiceReference<?>[] refs) {
        ServiceUtil.ungetServiceReferences((BundleContext)FrameworkUtil.getBundle(DeviceSnapshotsServlet.class).getBundleContext(), refs);
    }

    protected String marshal(Object object) {
        String result = null;
        ServiceReference<Marshaller>[] marshallerSRs = this.getXmlMarshallers();
        try {
            try {
                ServiceReference<Marshaller>[] serviceReferenceArray = marshallerSRs;
                int n = marshallerSRs.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference<Marshaller> marshallerSR = serviceReferenceArray[n2];
                    Marshaller marshaller = (Marshaller)FrameworkUtil.getBundle(DeviceSnapshotsServlet.class).getBundleContext().getService(marshallerSR);
                    result = marshaller.marshal(object);
                    if (result != null) {
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                logger.warn("Failed to marshal configuration.");
                this.ungetServiceReferences(marshallerSRs);
            }
        }
        finally {
            this.ungetServiceReferences(marshallerSRs);
        }
        return result;
    }
}

