/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.vp.componentsample.activity.explorer.services;

import org.eclipse.amalgam.explorer.activity.ui.api.manager.ActivityExplorerManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.kitalpha.ad.integration.sirius.listeners.SiriusHelper;
import org.polarsys.kitalpha.ad.services.manager.ViewpointActivationException;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.predicate.exceptions.EvaluationException;
import org.polarsys.kitalpha.vp.componentsample.activity.explorer.Activator;

public class ComponentSampleViewpointServices {
    public static final ComponentSampleViewpointServices SERVICE = new ComponentSampleViewpointServices();

    public boolean isReferenced(String vpid) {
        Session session = ActivityExplorerManager.INSTANCE.getSession();
        if (session != null) {
            return this.isReferenced(vpid, session);
        }
        return false;
    }

    private boolean isReferenced(String vpid, Session session) {
        ViewpointManager viewpointManager = this.getViewpointManager(session);
        boolean isReferenced = viewpointManager.isReferenced(vpid);
        boolean isFiltered = viewpointManager.isInactive(vpid);
        return isReferenced && !isFiltered;
    }

    public boolean isInactive(String vpid) {
        Session session = ActivityExplorerManager.INSTANCE.getSession();
        if (session != null) {
            return this.isInactive(vpid, session);
        }
        return false;
    }

    private boolean isInactive(String vpid, Session session) {
        ViewpointManager viewpointManager = this.getViewpointManager(session);
        boolean isFiltered = viewpointManager.isInactive(vpid);
        return isFiltered;
    }

    public void stopUse(final String id) {
        final Session session = ActivityExplorerManager.INSTANCE.getSession();
        if (session != null) {
            RecordingCommand cmd = new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    ViewpointManager viewpointManager = ComponentSampleViewpointServices.this.getViewpointManager(session);
                    try {
                        viewpointManager.setActivationState(id, false);
                    }
                    catch (ViewpointActivationException e) {
                        e.printStackTrace();
                    }
                }
            };
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)cmd);
        }
    }

    public void startUse(final String id) {
        final Session session = ActivityExplorerManager.INSTANCE.getSession();
        if (session != null) {
            RecordingCommand cmd = new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    ViewpointManager viewpointManager = ComponentSampleViewpointServices.this.getViewpointManager(session);
                    try {
                        viewpointManager.setActivationState(id, true);
                    }
                    catch (ViewpointActivationException e) {
                        e.printStackTrace();
                    }
                }
            };
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)cmd);
        }
    }

    private ViewpointManager getViewpointManager(Session session) {
        ViewpointManager viewpointManager = SiriusHelper.getViewpointManager((Session)session);
        return viewpointManager;
    }

    public void reference(final String vpid) {
        final Session session = ActivityExplorerManager.INSTANCE.getSession();
        if (session != null) {
            final ViewpointManager viewpointManager = this.getViewpointManager(session);
            RecordingCommand ref = new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    try {
                        if (!ComponentSampleViewpointServices.this.isReferenced(vpid, session)) {
                            viewpointManager.reference(vpid);
                        }
                    }
                    catch (ViewpointActivationException e) {
                        ComponentSampleViewpointServices.this.log("Can not Activate viewpoint", vpid, e);
                    }
                    catch (EvaluationException e) {
                        ComponentSampleViewpointServices.this.log("Can not evaluate predicate of the viewpoint", vpid, e);
                    }
                }
            };
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)ref);
        }
    }

    private void log(String message, String vpid, Throwable e) {
        Status status = new Status(4, "org.polarsys.kitalpha.vp.componentsample.activity.explorer", String.valueOf(message) + ": " + vpid, e);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    public void unreference(final String vpid) {
        Session session = ActivityExplorerManager.INSTANCE.getSession();
        if (session != null) {
            final ViewpointManager viewpointManager = this.getViewpointManager(session);
            RecordingCommand unRef = new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    try {
                        if (viewpointManager.isReferenced(vpid)) {
                            viewpointManager.unReference(vpid);
                        }
                    }
                    catch (ViewpointActivationException e) {
                        ComponentSampleViewpointServices.this.log("Can not activate viewpoint", vpid, e);
                    }
                    catch (EvaluationException e) {
                        ComponentSampleViewpointServices.this.log("Can not evaluate predicate of the viewpoint", vpid, e);
                    }
                }
            };
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)unRef);
        }
    }
}

