/*
 * generated by Xtext 2.9.1
 */
package org.eclipse.january.geometry.xtext.ui.contentassist

import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor
import org.eclipse.xtext.Assignment
import org.apache.commons.lang.StringUtils
import org.eclipse.xtext.RuleCall

/**
 * See https://www.eclipse.org/Xtext/documentation/304_ide_concepts.html#content-assist
 * on how to customize the content assistant.
 */
class IGESProposalProvider extends AbstractIGESProposalProvider {
	
	final int START = 1;
	final int GLOBAL = 2;
	final int DATA = 3;
	final int PARAM = 4;
	final int TERMINAL = 5;
	
	
	
	override public void completeIGES_Start(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		var int offset = context.getOffset();		
		var String proposal = StringUtils.leftPad('S      ' + (offset/81 + 1), 80, ' ') + '\n'
		
		acceptor.accept(createCompletionProposal(proposal, context));
	}
	
	
	override public void completeGlobal_Values(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal('1H,,', 'Delimiter', null, context));
		acceptor.accept(createCompletionProposal('1H;,', 'Separator', null, context));
		
		var String toEnd = getSectionEnd('G', context.getOffset(), context) + '\n';
		
		var String toEndwSpace = StringUtils.leftPad(toEnd, 81-(context.getOffset()%81), ' ');
		var String toEndSection = StringUtils.leftPad(toEnd, 80-(context.getOffset()%81), ' ');
		acceptor.accept(createCompletionProposal(toEndwSpace, 'End of line', null, context));
		acceptor.accept(createCompletionProposal('; '+toEndSection, 'End of Section', null, context))
	}
	
	
	override public void completeEntry_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal('     100', getTypeName(100), null, context));
		acceptor.accept(createCompletionProposal('     102', getTypeName(102), null, context));
		acceptor.accept(createCompletionProposal('     104', getTypeName(104), null, context));
		acceptor.accept(createCompletionProposal('     106', getTypeName(106), null, context));
		acceptor.accept(createCompletionProposal('     108', getTypeName(108), null, context));
		acceptor.accept(createCompletionProposal('     110', getTypeName(110), null, context));
		acceptor.accept(createCompletionProposal('     112', getTypeName(112), null, context));
		acceptor.accept(createCompletionProposal('     114', getTypeName(114), null, context));
		acceptor.accept(createCompletionProposal('     116', getTypeName(116), null, context));
		acceptor.accept(createCompletionProposal('     118', getTypeName(118), null, context));
		acceptor.accept(createCompletionProposal('     120', getTypeName(120), null, context));
		acceptor.accept(createCompletionProposal('     122', getTypeName(122), null, context));
		acceptor.accept(createCompletionProposal('     123', getTypeName(123), null, context));
		acceptor.accept(createCompletionProposal('     124', getTypeName(124), null, context));
		acceptor.accept(createCompletionProposal('     126', getTypeName(126), null, context));
		acceptor.accept(createCompletionProposal('     128', getTypeName(128), null, context));
		acceptor.accept(createCompletionProposal('     130', getTypeName(130), null, context));
		acceptor.accept(createCompletionProposal('     140', getTypeName(140), null, context));
		acceptor.accept(createCompletionProposal('     141', getTypeName(141), null, context));
		acceptor.accept(createCompletionProposal('     142', getTypeName(142), null, context));
		acceptor.accept(createCompletionProposal('     143', getTypeName(143), null, context));
		acceptor.accept(createCompletionProposal('     144', getTypeName(144), null, context));
		acceptor.accept(createCompletionProposal('     150', getTypeName(150), null, context));		
		acceptor.accept(createCompletionProposal('     152', getTypeName(152), null, context));
		acceptor.accept(createCompletionProposal('     154', getTypeName(154), null, context));
		acceptor.accept(createCompletionProposal('     156', getTypeName(156), null, context));
		acceptor.accept(createCompletionProposal('     158', getTypeName(158), null, context));
		acceptor.accept(createCompletionProposal('     160', getTypeName(160), null, context));
		acceptor.accept(createCompletionProposal('     162', getTypeName(162), null, context));
		acceptor.accept(createCompletionProposal('     164', getTypeName(164), null, context));
		acceptor.accept(createCompletionProposal('     168', getTypeName(168), null, context));
		acceptor.accept(createCompletionProposal('     180', getTypeName(180), null, context));
		acceptor.accept(createCompletionProposal('     186', getTypeName(186), null, context));
		acceptor.accept(createCompletionProposal('     190', getTypeName(190), null, context));
		acceptor.accept(createCompletionProposal('     192', getTypeName(192), null, context));
		acceptor.accept(createCompletionProposal('     194', getTypeName(194), null, context));
		acceptor.accept(createCompletionProposal('     196', getTypeName(196), null, context));
		acceptor.accept(createCompletionProposal('     198', getTypeName(198), null, context));
		acceptor.accept(createCompletionProposal('     308', getTypeName(308), null, context));
		acceptor.accept(createCompletionProposal('     314', getTypeName(314), null, context));
		acceptor.accept(createCompletionProposal('     408', getTypeName(408), null, context));
		acceptor.accept(createCompletionProposal('     502', getTypeName(502), null, context));
		acceptor.accept(createCompletionProposal('     504', getTypeName(504), null, context));
		acceptor.accept(createCompletionProposal('     508', getTypeName(508), null, context));
		acceptor.accept(createCompletionProposal('     510', getTypeName(510), null, context));
		acceptor.accept(createCompletionProposal('     514', getTypeName(514), null, context));	
	}
	
	override public void completeEntry_ParamData(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal('       1', context));
	}
	
	override public void completeEntry_Structure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal('       0', context));
		
	}
	
	override public void completeEntry_LineFont(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal('       0', 'No line font', null, context));
		acceptor.accept(createCompletionProposal('       1', 'Solid', null, context));
		acceptor.accept(createCompletionProposal('       2', 'Dashed', null, context));
		acceptor.accept(createCompletionProposal('       3', 'Phantom', null, context));
		acceptor.accept(createCompletionProposal('       4', 'Centerline', null, context));
		acceptor.accept(createCompletionProposal('       5', 'Dotted', null, context));
	}
	
	override public void completeEntry_Level(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal('       0', context));
	}
	
	override public void completeEntry_View(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal('       0', context));

	}
	
	override public void completeEntry_TransformMatrix(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal('       0', context));

	}
	
	override public void completeEntry_Status(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal('00000001', context));
	}
	
	override public void completeEntry_Index(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(getSectionEnd('D', context.getOffset(), context) + '\n', context));
	}
	
	override public void completeEntry_LineWeight(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		//acceptor.accept()
	}
	
	override public void completeEntry_Color(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {

	}
	
	override public void completeEntry_ParamLines(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {

	}
	
	override public void completeEntry_Form(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {

	}
	
	override public void completeEntry_EntityLabel(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {

	}
	
	override public void completeEntry_SubNum(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {

	}
	
	
	
	
	
	
	def private String getSectionEnd(char section, int offset, ContentAssistContext context) {	
		
		var int row = offset/81;
		
		var int secNum = findSecNum(row, section, context);
		var String intstr = section + StringUtils.leftPad(Integer.toString(secNum), 7, ' ');
		return intstr;
		
		
	}
	
	def private int findSecNum(int row, char sec, ContentAssistContext context) {
		var int index = 0;
		var int r = row-1;
		while(r>=0 && context.getDocument().getChar(81*r + 72)==sec) {
			r--;
			index++;
		}
		return index +1;
		
	}
	
	def String getTypeName(int type) {
		switch(type){
			case 100: 'Circular Arc'
			case 102: 'Composite Curve'
			case 104: 'Conic Arc'
			case 106: 'Copious Data'
			case 108: 'Plane'
			case 110: 'Line'
			case 112: 'P. Spline Curve'
			case 114: 'P. Spline Surface'
			case 116: 'Point'
			case 118: 'Ruled Surface'
			case 120: 'Surface of Revolution'
			case 122: 'Tabulated Cylinder'
			case 123: 'Direction'
			case 124: 'Transformation Matrix'
			case 126: 'Rat. B-Spline Curve'
			case 128: 'Rat. B-Spline Surface'
			case 130: 'Offset Curve'
			case 140: 'Offset Surface'
			case 141: 'Boundary'
			case 142: 'Curve on a P. Surface'
			case 143: 'Bounded Surface'
			case 144: 'Trimmed Surface'
			case 150: 'Block'
			case 152: 'Right Angular Wedge'
			case 154: 'Right Circ. Cylinder'
			case 156: 'Right Circular Cone'
			case 158: 'Sphere'
			case 160: 'Torus'
			case 162: 'Solid of Revolution'
			case 164: 'Solid of L. Extrusion'
			case 168: 'Ellipsoid'
			case 180: 'Boolean Tree'
			case 186: 'M. Solid B-Rep Object'
			case 190: 'Plane Surface'
			case 192: 'Right Cir. Cyl. Surface'
			case 194: 'Right Cir. Con. Surface'
			case 196: 'Spherical Surface'
			case 198: 'Toroidal Surface'
			case 308: 'Subfigure Definition'
			case 314: 'Color definition'
			case 408: 'Sing. Subfigure Instance'
			case 502: 'Vertex List'
			case 504: 'Edge List'
			case 508: 'Loop'
			case 510: 'Face'
			case 514: 'Shell'
			default: 'Unknown Entity'
		}
	}
	
}
