/*
 * generated by Xtext 2.9.1
 */
package org.eclipse.january.geometry.xtext.ui.labeling

import com.google.inject.Inject
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider
import org.eclipse.january.geometry.xtext.iGES.IGES
import org.eclipse.january.geometry.xtext.iGES.Start
import org.eclipse.january.geometry.xtext.iGES.Data
import org.eclipse.january.geometry.xtext.iGES.Parameters
import org.eclipse.january.geometry.xtext.iGES.End
import org.eclipse.january.geometry.xtext.iGES.Entry
import org.eclipse.january.geometry.xtext.iGES.PEntry
import org.eclipse.january.geometry.xtext.iGES.HString
import org.eclipse.january.geometry.xtext.iGES.Pointer
import org.eclipse.january.geometry.xtext.iGES.Param
import org.eclipse.january.geometry.xtext.iGES.Global

/**
 * Provides labels for EObjects.
 * 
 * See https://www.eclipse.org/Xtext/documentation/304_ide_concepts.html#label-provider
 */
class IGESLabelProvider extends DefaultEObjectLabelProvider {

	@Inject
	new(AdapterFactoryLabelProvider delegate) {
		super(delegate);
	}

	def text(IGES iges) {
		'IGES file data'
	}
	
	def text(Start start) {
		'Start Section'
	}
	
	def text(Global global) {
		'Global params'
	}
	
	def text(Data data) {
		'Data Entries'
	}
	
	def text(Parameters param) {
		'Parameter Data'
	}
	
	def text(End end) {
		'End Section'
	}
	
	def text(Entry e) {
		getTypeName(e.getType()) + ' definition'
		
	}
	
	def text(PEntry e) {
		getTypeName(e.getType()) + ' data'
	}
	
	def text(HString str) {
		var String hol = str.getVal();
		return hol.substring(hol.indexOf('H')+1);
	}
	
	def text(Pointer p) {
		Integer.toString(p.getVal())
	}
	
	def text(Param p) {
		Double.toString(p.getVal())
	}
	
	def String getTypeName(int type) {
		switch(type){
			case 100: 'Circular Arc'
			case 102: 'Composite Curve'
			case 104: 'Conic Arc'
			case 106: 'Copious Data'
			case 108: 'Plane'
			case 110: 'Line'
			case 112: 'P. Spline Curve'
			case 114: 'P. Spline Surface'
			case 116: 'Point'
			case 118: 'Ruled Surface'
			case 120: 'Surface of Revolution'
			case 122: 'Tabulated Cylinder'
			case 123: 'Direction'
			case 124: 'Transformation Matrix'
			case 126: 'Rat. B-Spline Curve'
			case 128: 'Rat. B-Spline Surface'
			case 130: 'Offset Curve'
			case 140: 'Offset Surface'
			case 141: 'Boundary'
			case 142: 'Curve on a P. Surface'
			case 143: 'Bounded Surface'
			case 144: 'Trimmed Surface'
			case 150: 'Block'
			case 152: 'Right Angular Wedge'
			case 154: 'Right Circ. Cylinder'
			case 156: 'Right Circular Cone'
			case 158: 'Sphere'
			case 160: 'Torus'
			case 162: 'Solid of Revolution'
			case 164: 'Solid of L. Extrusion'
			case 168: 'Ellipsoid'
			case 180: 'Boolean Tree'
			case 186: 'M. Solid B-Rep Object'
			case 190: 'Plane Surface'
			case 192: 'Right Cir. Cyl. Surface'
			case 194: 'Right Cir. Con. Surface'
			case 196: 'Spherical Surface'
			case 198: 'Toroidal Surface'
			case 308: 'Subfigure Definition'
			case 314: 'Color definition'
			case 408: 'Sing. Subfigure Instance'
			case 502: 'Vertex List'
			case 504: 'Edge List'
			case 508: 'Loop'
			case 510: 'Face'
			case 514: 'Shell'
			default: 'Unknown Entity'
		}
	}

}
