/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.january.geometry.BoundingBox;
import org.eclipse.january.geometry.GeometryFactory;
import org.eclipse.january.geometry.GeometryPackage;
import org.eclipse.january.geometry.HeatExchanger;
import org.eclipse.january.geometry.Junction;
import org.eclipse.january.geometry.Pipe;
import org.eclipse.january.geometry.Triangle;
import org.eclipse.january.geometry.Vertex;
import org.eclipse.january.geometry.impl.ShapeImpl;
import org.eclipse.january.geometry.util.MeshUtils;

public class HeatExchangerImpl
extends ShapeImpl
implements HeatExchanger {
    protected Pipe pipe;
    protected Junction input;
    protected Junction output;
    protected boolean meshChanged = false;
    protected final int SEGMENTS = 15;
    protected final int RESOLUTION = 25;

    protected HeatExchangerImpl() {
    }

    protected EList<Triangle> createPipeToPoint(Vertex point) {
        BoundingBox start = this.getPipe().getLowerEdge();
        double[] startPoint = new double[]{(start.getMaxX() - start.getMinX()) / 2.0 + start.getMinX(), (start.getMaxY() - start.getMinY()) / 2.0 + start.getMinY(), (start.getMaxZ() - start.getMinZ()) / 2.0 + start.getMinZ()};
        BoundingBox end = this.pipe.getUpperEdge();
        double[] endPoint = new double[]{(end.getMaxX() - end.getMinX()) / 2.0 + end.getMinX(), (end.getMaxY() - end.getMinY()) / 2.0 + end.getMinY(), (end.getMaxZ() - end.getMinZ()) / 2.0 + end.getMinZ()};
        double[] axis = new double[]{endPoint[0] - startPoint[0], endPoint[1] - startPoint[1], endPoint[2] - startPoint[2]};
        double[] wallStart = new double[]{startPoint[0] + axis[0] * 0.1, startPoint[1] + axis[1] * 0.1, startPoint[2] + axis[2] * 0.1};
        double[] wallEnd = new double[]{endPoint[0] - axis[0] * 0.1, endPoint[1] - axis[1] * 0.1, endPoint[2] - axis[2] * 0.1};
        double[] primaryVector = new double[]{wallEnd[0] - wallStart[0], wallEnd[1] - wallStart[1], wallEnd[2] - wallStart[2]};
        double axisMag = Math.pow(primaryVector[0], 2.0) + Math.pow(primaryVector[1], 2.0) + Math.pow(primaryVector[2], 2.0);
        double[] targetVector = new double[]{point.getX() - wallStart[0], point.getY() - wallStart[1], point.getZ() - wallStart[2]};
        double dotProduct = primaryVector[0] * targetVector[0] + primaryVector[1] * targetVector[1] + primaryVector[2] * targetVector[2];
        double step = dotProduct / axisMag;
        double[] intersection = new double[]{wallStart[0] + primaryVector[0] * step, wallStart[1] + primaryVector[1] * step, wallStart[2] + primaryVector[2] * step};
        Vertex line = GeometryFactory.eINSTANCE.createVertex();
        line.setX(point.getX() - intersection[0]);
        line.setY(point.getY() - intersection[1]);
        line.setZ(point.getZ() - intersection[2]);
        Vertex axisOfRotation = GeometryFactory.eINSTANCE.createVertex();
        axisOfRotation.setX(-line.getZ());
        axisOfRotation.setY(0.0);
        axisOfRotation.setZ(line.getX());
        double lineMagnitude = Math.sqrt(Math.pow(line.getX(), 2.0) + Math.pow(line.getY(), 2.0) + Math.pow(line.getZ(), 2.0));
        double rotationAmount = Math.acos(line.getY() / lineMagnitude);
        double length = Math.sqrt(Math.pow(intersection[0] - point.getX(), 2.0) + Math.pow(intersection[1] - point.getY(), 2.0) + Math.pow(intersection[2] - point.getZ(), 2.0));
        double[] directVector = new double[]{point.getX() - intersection[0], point.getY() - intersection[1], point.getZ() - intersection[2]};
        double directLength = Math.sqrt(Math.pow(directVector[0], 2.0) + Math.pow(directVector[1], 2.0) + Math.pow(directVector[2], 2.0));
        double[] normalizedDirect = new double[]{directVector[0] / directLength, directVector[1] / directLength, directVector[2] / directLength};
        double[] vertices = MeshUtils.createTube(length, this.pipe.getRadius(), this.pipe.getRadius(), 25, 15);
        vertices = MeshUtils.rotatePointsAboutAxis(vertices, axisOfRotation, rotationAmount);
        Vertex intersectionPoint = GeometryFactory.eINSTANCE.createVertex();
        intersectionPoint.setX(intersection[0] + normalizedDirect[0] * length / 2.0 - this.center.getX());
        intersectionPoint.setY(intersection[1] + normalizedDirect[1] * length / 2.0 - this.center.getY());
        intersectionPoint.setZ(intersection[2] + normalizedDirect[2] * length / 2.0 - this.center.getZ());
        vertices = MeshUtils.centerPoints(vertices, intersectionPoint);
        return MeshUtils.createTubeMesh(vertices, 25, 15);
    }

    @Override
    protected EClass eStaticClass() {
        return GeometryPackage.Literals.HEAT_EXCHANGER;
    }

    @Override
    public Pipe getPipe() {
        if (this.pipe != null && this.pipe.eIsProxy()) {
            InternalEObject oldPipe = (InternalEObject)this.pipe;
            this.pipe = (Pipe)this.eResolveProxy(oldPipe);
            if (this.pipe != oldPipe && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 8, (Object)oldPipe, (Object)this.pipe));
            }
        }
        return this.pipe;
    }

    public Pipe basicGetPipe() {
        return this.pipe;
    }

    @Override
    public void setPipe(Pipe newPipe) {
        if (newPipe != this.pipe) {
            Pipe oldPipe = this.pipe;
            this.pipe = newPipe;
            if (newPipe != oldPipe) {
                this.meshChanged = true;
            }
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldPipe, (Object)this.pipe));
            }
        }
    }

    @Override
    public Junction getInput() {
        if (this.input != null && this.input.eIsProxy()) {
            InternalEObject oldInput = (InternalEObject)this.input;
            this.input = (Junction)this.eResolveProxy(oldInput);
            if (this.input != oldInput && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 9, (Object)oldInput, (Object)this.input));
            }
        }
        return this.input;
    }

    public Junction basicGetInput() {
        return this.input;
    }

    @Override
    public void setInput(Junction newInput) {
        if (newInput != this.input) {
            Junction oldInput = this.input;
            this.input = newInput;
            if (newInput != oldInput) {
                this.meshChanged = true;
            }
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldInput, (Object)this.input));
            }
        }
    }

    @Override
    public Junction getOutput() {
        if (this.output != null && this.output.eIsProxy()) {
            InternalEObject oldOutput = (InternalEObject)this.output;
            this.output = (Junction)this.eResolveProxy(oldOutput);
            if (this.output != oldOutput && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 10, (Object)oldOutput, (Object)this.output));
            }
        }
        return this.output;
    }

    public Junction basicGetOutput() {
        return this.output;
    }

    @Override
    public void setOutput(Junction newOutput) {
        if (newOutput != this.output) {
            Junction oldOutput = this.output;
            this.output = newOutput;
            if (newOutput != oldOutput) {
                this.meshChanged = true;
            }
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldOutput, (Object)this.output));
            }
        }
    }

    @Override
    public EList<Triangle> getTriangles() {
        if (this.triangles == null) {
            this.triangles = new BasicEList();
        }
        if (!this.meshChanged) {
            return this.triangles;
        }
        this.triangles.clear();
        if (this.pipe == null) {
            return this.triangles;
        }
        this.triangles = this.pipe.getTriangles();
        double wallWidth = this.pipe.getRadius() * 4.0;
        double wallHeight = this.pipe.getHeight() * 0.8;
        double[] wallCoords = MeshUtils.createRectangularPrism(wallWidth, wallHeight, wallWidth);
        wallCoords = MeshUtils.rotatePoints(wallCoords, this.pipe.getRotationX(), this.pipe.getRotationY(), this.pipe.getRotationZ());
        this.triangles.addAll(MeshUtils.createRectangularPrismMesh(wallCoords));
        if (this.input != null) {
            this.triangles.addAll(this.createPipeToPoint(this.input.getCenter()));
        }
        if (this.output != null) {
            this.triangles.addAll(this.createPipeToPoint(this.output.getCenter()));
        }
        return this.triangles;
    }

    @Override
    public void setCenter(Vertex newCenter) {
        if (this.pipe != null) {
            this.pipe.setCenter(newCenter);
        }
        super.setCenter(newCenter);
    }

    @Override
    public Object clone() {
        HeatExchanger clone = GeometryFactory.eINSTANCE.createHeatExchanger();
        clone.copy(this);
        return clone;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                if (resolve) {
                    return this.getPipe();
                }
                return this.basicGetPipe();
            }
            case 9: {
                if (resolve) {
                    return this.getInput();
                }
                return this.basicGetInput();
            }
            case 10: {
                if (resolve) {
                    return this.getOutput();
                }
                return this.basicGetOutput();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setPipe((Pipe)newValue);
                return;
            }
            case 9: {
                this.setInput((Junction)newValue);
                return;
            }
            case 10: {
                this.setOutput((Junction)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setPipe(null);
                return;
            }
            case 9: {
                this.setInput(null);
                return;
            }
            case 10: {
                this.setOutput(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.pipe != null;
            }
            case 9: {
                return this.input != null;
            }
            case 10: {
                return this.output != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

