/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.eavp.viz.service.IVizServiceFactory;
import org.eclipse.january.form.ICEResource;
import org.eclipse.january.form.VizResource;
import org.eclipse.january.form.internal.VizServiceFactoryHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHandler {
    private static final Logger logger = LoggerFactory.getLogger(ResourceHandler.class);
    private static ArrayList<String> vizFileExtensions;

    public ResourceHandler() {
        if (vizFileExtensions == null) {
            vizFileExtensions = new ArrayList(3);
        }
    }

    public ICEResource getResource(String filePath) throws IOException {
        IVizServiceFactory factory;
        if (vizFileExtensions.size() == 0 && (factory = VizServiceFactoryHolder.getFactory()) != null) {
            String[] stringArray = factory.getServiceNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String service = stringArray[n2];
                vizFileExtensions.addAll(factory.get(service).getSupportedExtensions());
                ++n2;
            }
        }
        ICEResource resource = null;
        File file = null;
        if (filePath.isEmpty()) {
            logger.info("ResourceHandler Message: The file path was empty!");
            return resource;
        }
        file = new File(filePath);
        if (file != null && file.exists()) {
            int lastDot = filePath.lastIndexOf(".");
            String fileExt = "";
            if (lastDot == -1) {
                logger.info("ResourceHandler Message: The file path does not have a valid file extension: " + filePath);
                return resource;
            }
            fileExt = filePath.substring(lastDot + 1);
            resource = vizFileExtensions.contains(fileExt.toLowerCase()) ? new VizResource(file) : new ICEResource(file);
        }
        return resource;
    }

    public ICEResource getResource(String filePath, String name) throws IOException {
        ICEResource resource = this.getResource(filePath);
        if (resource != null) {
            resource.setName(name);
        }
        return resource;
    }

    public ICEResource getResource(String filePath, String name, int id) throws IOException {
        ICEResource resource = this.getResource(filePath, name);
        if (resource != null) {
            resource.setId(id);
        }
        return resource;
    }

    public ICEResource getResource(String filePath, String name, int id, String desc) throws IOException {
        ICEResource resource = this.getResource(filePath, name, id);
        if (resource != null) {
            resource.setDescription(desc);
        }
        return resource;
    }
}

