/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.bootstrap.customprovider;

import jakarta.validation.BootstrapConfiguration;
import jakarta.validation.ClockProvider;
import jakarta.validation.Configuration;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.spi.BootstrapState;
import jakarta.validation.spi.ConfigurationState;
import jakarta.validation.spi.ValidationProvider;
import jakarta.validation.valueextraction.ValueExtractor;
import java.io.InputStream;
import org.hibernate.beanvalidation.tck.tests.AbstractBootstrapFailureTCKTest;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class BootstrapNonAvailableValidationProviderTest
extends AbstractBootstrapFailureTCKTest {
    @Override
    protected Class<? extends Exception> acceptedDeploymentExceptionType() {
        return ValidationException.class;
    }

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)BootstrapNonAvailableValidationProviderTest.webArchiveBuilder().withTestClass(BootstrapNonAvailableValidationProviderTest.class)).withValidationXml("validation-BootstrapUnknownCustomProviderTest.xml")).build();
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping-validation", id="f"), @SpecAssertion(section="exception", id="a")})
    public void testUnknownProviderConfiguredInValidationXml() {
        Validation.byDefaultProvider().configure().buildValidatorFactory();
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping-validation", id="f"), @SpecAssertion(section="exception", id="a")})
    public void testConfiguredValidationProviderIsNotLoadable() {
        Validation.byProvider(DummyValidationProvider.class).configure();
    }

    public static class DummyValidatorConfiguration
    implements Configuration<DummyValidatorConfiguration> {
        public DummyValidatorConfiguration ignoreXmlConfiguration() {
            return null;
        }

        public DummyValidatorConfiguration messageInterpolator(MessageInterpolator interpolator) {
            return null;
        }

        public DummyValidatorConfiguration traversableResolver(TraversableResolver resolver) {
            return null;
        }

        public DummyValidatorConfiguration constraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
            return null;
        }

        public DummyValidatorConfiguration parameterNameProvider(ParameterNameProvider parameterNameProvider) {
            return null;
        }

        public DummyValidatorConfiguration clockProvider(ClockProvider clockProvider) {
            return null;
        }

        public DummyValidatorConfiguration addMapping(InputStream stream) {
            return null;
        }

        public DummyValidatorConfiguration addProperty(String name, String value) {
            return null;
        }

        public DummyValidatorConfiguration addValueExtractor(ValueExtractor<?> extractor) {
            return null;
        }

        public MessageInterpolator getDefaultMessageInterpolator() {
            return null;
        }

        public TraversableResolver getDefaultTraversableResolver() {
            return null;
        }

        public ConstraintValidatorFactory getDefaultConstraintValidatorFactory() {
            return null;
        }

        public ParameterNameProvider getDefaultParameterNameProvider() {
            return null;
        }

        public ClockProvider getDefaultClockProvider() {
            return null;
        }

        public BootstrapConfiguration getBootstrapConfiguration() {
            return null;
        }

        public ValidatorFactory buildValidatorFactory() {
            return null;
        }
    }

    public static class DummyValidationProvider
    implements ValidationProvider<DummyValidatorConfiguration> {
        public DummyValidationProvider() {
            throw new RuntimeException("ups");
        }

        public DummyValidatorConfiguration createSpecializedConfiguration(BootstrapState state) {
            return null;
        }

        public Configuration<?> createGenericConfiguration(BootstrapState state) {
            return null;
        }

        public ValidatorFactory buildValidatorFactory(ConfigurationState configurationState) {
            return null;
        }
    }
}

