/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.serializer.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.serializer.descriptionunit.DescriptionUnitSerializer;
import org.eclipse.mylyn.docs.intent.serializer.internal.IntentDocumentSerializerSwitch;
import org.eclipse.mylyn.docs.intent.serializer.internal.IntentElementSerializer;

public final class IntentDocumentSerializer {
    private IntentDocumentSerializer() {
    }

    public static String serialize(IntentDocument document, IntentElementSerializer serializer) {
        StringBuilder renderedForm = new StringBuilder();
        renderedForm.append(serializer.tabulation());
        serializer.setCurrentIndendationLevel(serializer.getCurrentIndendationLevel() + 1);
        int initalOffset = serializer.getCurrentOffset();
        renderedForm.append("Document");
        int initialLength = renderedForm.length();
        renderedForm.append(" ");
        if (document.getTitle() != null) {
            DescriptionUnitSerializer descriptionUnitSerializer = new DescriptionUnitSerializer(new IntentDocumentSerializerSwitch(serializer));
            renderedForm.append(descriptionUnitSerializer.serializeSectionTitle((EObject)document.getTitle(), initalOffset + renderedForm.length()));
            serializer.getPositionManager().addIntentPositionManagerInformations(descriptionUnitSerializer.getPositionManager());
            renderedForm.append(" ");
        }
        renderedForm.append("{\n");
        for (EObject content : document.getSubSections()) {
            serializer.setCurrentOffset(initalOffset + renderedForm.length());
            renderedForm.append(serializer.serialize(content));
        }
        serializer.setCurrentIndendationLevel(serializer.getCurrentIndendationLevel() - 1);
        renderedForm.append(String.valueOf(serializer.tabulation()) + "}" + "\n");
        serializer.setCurrentOffset(initalOffset + renderedForm.length());
        serializer.setPositionForElement((EObject)document, initalOffset, renderedForm.length(), initialLength);
        return renderedForm.toString();
    }
}

