/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.greycat;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterators;
import greycat.Callback;
import greycat.Graph;
import greycat.Node;
import greycat.NodeIndex;
import greycat.Query;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphDatabase;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNodeIndex;
import org.eclipse.hawk.greycat.GreycatNode;
import org.eclipse.hawk.greycat.GreycatTransaction;
import org.eclipse.hawk.greycat.lucene.GreycatLuceneIndexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGreycatDatabase
implements ITimeAwareGraphDatabase {
    protected static final String SOFT_DELETED_KEY = "h_softDeleted";
    protected static final String NODE_LABEL_IDX = "h_nodeLabel";
    protected static final int SAVE_EVERY = 10000;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGreycatDatabase.class);
    private Cache<NodeKey, GreycatNode> nodeCache;
    protected File storageFolder;
    private File tempFolder;
    private Graph graph;
    private NodeIndex nodeLabelIndex;
    private NodeIndex softDeleteIndex;
    private IGraphDatabase.Mode mode = IGraphDatabase.Mode.TX_MODE;
    protected GreycatLuceneIndexer luceneIndexer;
    private Set<GreycatNode> currentDirtyNodes = new HashSet<GreycatNode>();
    private Set<GreycatNode> currentOpenNodes = new HashSet<GreycatNode>();
    private long world = 0L;
    private long time = 0L;
    public static final int DEFAULT_CACHE_EXPIRATION_TIME = 5;
    public static final TimeUnit DEFAULT_CACHE_EXPIRATION_UNIT = TimeUnit.SECONDS;
    private long cacheExpiration = 5L;
    private TimeUnit cacheExpirationUnit = DEFAULT_CACHE_EXPIRATION_UNIT;

    protected abstract Graph createGraph();

    private static void deleteRecursively(File f) throws IOException {
        if (!f.exists()) {
            return;
        }
        Files.walkFileTree(f.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public long getWorld() {
        return this.world;
    }

    public void setWorld(long world) {
        this.world = world;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String getPath() {
        return this.storageFolder.getAbsolutePath();
    }

    public void run(File parentFolder, IConsole c) {
        this.storageFolder = parentFolder;
        this.tempFolder = new File(this.storageFolder, "temp");
        this.reconnect();
    }

    public void shutdown() throws Exception {
        this.shutdownHelpers();
        if (this.graph != null) {
            this.graph.disconnect(result -> LOGGER.info("Disconnected from GreyCat graph at {}", (Object)this.getPath()));
            this.graph = null;
        }
    }

    public void delete() throws Exception {
        this.shutdownHelpers();
        if (this.graph != null) {
            CompletableFuture done = new CompletableFuture();
            this.graph.disconnect(result -> {
                try {
                    AbstractGreycatDatabase.deleteRecursively(this.storageFolder);
                }
                catch (IOException e) {
                    LOGGER.error("Error while deleting Greycat storage", (Throwable)e);
                }
                done.complete(true);
            });
            done.join();
            this.graph = null;
        }
    }

    protected void shutdownHelpers() {
        if (this.nodeCache != null) {
            this.nodeCache.invalidateAll();
            this.nodeCache = null;
        }
        if (this.luceneIndexer != null) {
            this.luceneIndexer.shutdown();
            this.luceneIndexer = null;
        }
        this.currentDirtyNodes.clear();
        this.currentOpenNodes.clear();
        if (this.softDeleteIndex != null) {
            this.softDeleteIndex.free();
            this.softDeleteIndex = null;
        }
        if (this.nodeLabelIndex != null) {
            this.nodeLabelIndex.free();
            this.nodeLabelIndex = null;
        }
    }

    public ITimeAwareGraphNodeIndex getOrCreateNodeIndex(String name) {
        try {
            return this.luceneIndexer.getIndex(name);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get index " + name, (Throwable)e);
            return null;
        }
    }

    public ITimeAwareGraphNodeIndex getMetamodelIndex() {
        return this.getOrCreateNodeIndex("_hawkMetamodelIndex");
    }

    public ITimeAwareGraphNodeIndex getFileIndex() {
        return this.getOrCreateNodeIndex("_hawkFileIndex");
    }

    public IGraphTransaction beginTransaction() throws Exception {
        if (this.mode == IGraphDatabase.Mode.NO_TX_MODE) {
            this.exitBatchMode();
        }
        return new GreycatTransaction(this);
    }

    public boolean isTransactional() {
        return true;
    }

    public void enterBatchMode() {
        if (this.mode == IGraphDatabase.Mode.TX_MODE) {
            this.commitLuceneIndex();
            this.save();
            this.mode = IGraphDatabase.Mode.NO_TX_MODE;
        }
    }

    public void exitBatchMode() {
        if (this.mode == IGraphDatabase.Mode.NO_TX_MODE) {
            this.commitLuceneIndex();
            this.save();
            this.mode = IGraphDatabase.Mode.TX_MODE;
        }
    }

    public IGraphIterable<GreycatNode> allNodes(String label) {
        return this.allNodes(label, this.time);
    }

    public IGraphIterable<GreycatNode> allNodes(final String label, final long time) {
        return new IGraphIterable<GreycatNode>(){

            public Iterator<GreycatNode> iterator() {
                long[] ids = this.getRawIdentifiers(label, time);
                return Iterators.filter((Iterator)Iterators.transform((Iterator)IntStream.range(0, ids.length).iterator(), i -> AbstractGreycatDatabase.this.lookup(AbstractGreycatDatabase.this.world, time, ids[i])), n -> n.isAlive());
            }

            public int size() {
                return Iterators.size(this.iterator());
            }

            public GreycatNode getSingle() {
                return this.iterator().next();
            }

            private long[] getRawIdentifiers(String label2, long time2) {
                Query query = AbstractGreycatDatabase.this.graph.newQuery();
                query.setTime(time2);
                query.setWorld(AbstractGreycatDatabase.this.world);
                query.add(AbstractGreycatDatabase.NODE_LABEL_IDX, label2);
                return AbstractGreycatDatabase.this.nodeLabelIndex.selectByQuery(query);
            }
        };
    }

    public GreycatNode createNode(Map<String, Object> props, String label) {
        Node node = this.graph.newNode(this.world, this.time);
        node.set(NODE_LABEL_IDX, 2, (Object)label);
        this.nodeLabelIndex.update(node);
        GreycatNode n = new GreycatNode(this, this.world, this.time, node.id(), node);
        if (props != null) {
            n.setProperties(props);
        }
        return n;
    }

    protected void markDirty(GreycatNode n) {
        this.currentDirtyNodes.add(n);
    }

    protected void markOpen(GreycatNode n) {
        this.currentOpenNodes.add(n);
    }

    protected void markClosed(GreycatNode n) {
        if (this.currentOpenNodes.remove(n) && this.currentOpenNodes.isEmpty() && this.mode == IGraphDatabase.Mode.NO_TX_MODE && this.currentDirtyNodes.size() > 10000) {
            this.save();
        }
    }

    protected void save() {
        CompletableFuture result = new CompletableFuture();
        this.graph.save(saved -> this.softDeleteIndex.find(results -> {
            Semaphore sem = new Semaphore(-((Node[])results).length + 1);
            Node[] nodeArray = results;
            int n = ((Node[])results).length;
            int n2 = 0;
            while (n2 < n) {
                Node n3 = nodeArray[n2];
                this.hardDelete(new GreycatNode(this, n3.world(), n3.time(), n3.id(), n3), dropped -> sem.release());
                ++n2;
            }
            try {
                sem.acquire();
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (((Node[])results).length > 0) {
                this.graph.save(savedAgain -> {
                    boolean bl = result.complete(savedAgain);
                });
            } else {
                result.complete(saved);
            }
        }, this.world, this.time, new String[0]));
        result.join();
        for (GreycatNode dirtyNode : new ArrayList<GreycatNode>(this.currentDirtyNodes)) {
            this.nodeCache.invalidate((Object)new NodeKey(dirtyNode));
        }
        this.currentDirtyNodes.clear();
    }

    public IGraphEdge createRelationship(IGraphNode start, IGraphNode end, String type) {
        return this.createRelationship(start, end, type, Collections.emptyMap());
    }

    public IGraphEdge createRelationship(IGraphNode start, IGraphNode end, String type, Map<String, Object> props) {
        GreycatNode gStart = (GreycatNode)start;
        GreycatNode gEnd = (GreycatNode)end;
        return gStart.addEdge(type, gEnd, props);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public GreycatNode getNodeById(Object id) {
        return this.getNodeByIdAt(id, this.time);
    }

    public GreycatNode getNodeByIdAt(Object id, Long timepoint) {
        if (id instanceof String) {
            id = Long.valueOf((String)id);
        }
        if (timepoint == null) {
            timepoint = this.time;
        }
        return this.lookup(this.world, timepoint, (Long)id);
    }

    public boolean nodeIndexExists(String name) {
        return this.luceneIndexer.indexExists(name);
    }

    public String getHumanReadableName() {
        return "GreyCat Database";
    }

    public String getTempDir() {
        return this.tempFolder.getAbsolutePath();
    }

    public IGraphDatabase.Mode currentMode() {
        return this.mode;
    }

    public Set<String> getNodeIndexNames() {
        return this.luceneIndexer.getIndexNames();
    }

    public Set<String> getKnownMMUris() {
        HashSet<String> mmURIs = new HashSet<String>();
        for (IGraphNode node : this.getMetamodelIndex().query("*", (Object)"*")) {
            String mmURI = (String)node.getProperty("_hawkid");
            mmURIs.add(mmURI);
        }
        return mmURIs;
    }

    public boolean reconnect() {
        CompletableFuture<Boolean> connected = new CompletableFuture<Boolean>();
        if (this.nodeCache != null) {
            this.nodeCache.invalidateAll();
        }
        if (this.graph != null) {
            try {
                this.luceneIndexer.rollback();
            }
            catch (IOException e) {
                LOGGER.error("Could not rollback Lucene", (Throwable)e);
            }
            this.graph.storage().disconnect(disconnectedStorage -> this.connect(connected));
        } else {
            try {
                this.luceneIndexer = new GreycatLuceneIndexer(this, new File(this.storageFolder, "lucene"));
            }
            catch (IOException e) {
                LOGGER.error("Could not set up Lucene indexing", (Throwable)e);
            }
            this.connect(connected);
        }
        try {
            return connected.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public long getCacheExpiration() {
        return this.cacheExpiration;
    }

    public TimeUnit getCacheExpirationUnit() {
        return this.cacheExpirationUnit;
    }

    public void setCacheExpiration(long cacheExpiry, TimeUnit cacheExpiryUnit) {
        this.cacheExpiration = cacheExpiry;
        this.cacheExpirationUnit = cacheExpiryUnit;
    }

    protected void connect(CompletableFuture<Boolean> cConnected) {
        this.nodeCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(this.cacheExpiration, this.cacheExpirationUnit).build();
        this.graph = this.createGraph();
        this.exitBatchMode();
        this.graph.connect(connected -> {
            if (connected.booleanValue()) {
                this.graph.declareIndex(this.world, NODE_LABEL_IDX, nodeIndex -> {
                    this.nodeLabelIndex = nodeIndex;
                    this.graph.declareIndex(this.world, SOFT_DELETED_KEY, softDeleteIndex -> {
                        this.softDeleteIndex = softDeleteIndex;
                        cConnected.complete(true);
                    }, new String[]{SOFT_DELETED_KEY});
                }, new String[]{NODE_LABEL_IDX});
            } else {
                LOGGER.error("Could not connect to Greycat DB");
                cConnected.complete(false);
            }
        });
    }

    protected void hardDelete(GreycatNode gn, Callback<?> callback) {
        this.unlink(gn);
        Throwable throwable = null;
        Object var4_5 = null;
        try (GreycatNode.NodeReader rn = gn.getNodeReader();){
            Node node = rn.get();
            node.drop(callback);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.nodeCache.invalidate((Object)new NodeKey(gn));
    }

    protected void softDelete(GreycatNode gn) {
        this.unlink(gn);
        Throwable throwable = null;
        Object var3_4 = null;
        try (GreycatNode.NodeReader rn = gn.getNodeReader();){
            Node node = rn.get();
            node.set(SOFT_DELETED_KEY, 1, (Object)true);
            this.softDeleteIndex.update(node);
            rn.markDirty();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void unlink(GreycatNode gn) {
        for (IGraphEdge e : gn.getEdges()) {
            e.delete();
        }
        Throwable throwable = null;
        Iterator<IGraphEdge> iterator = null;
        try (GreycatNode.NodeReader rn = gn.getNodeReader();){
            Node n = rn.get();
            this.softDeleteIndex.unindex(n);
            this.nodeLabelIndex.unindex(n);
            this.luceneIndexer.remove(gn);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void commitLuceneIndex() {
        try {
            this.luceneIndexer.commit();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to commit Lucene index", (Throwable)ex);
        }
    }

    protected GreycatNode lookup(long world, long time, long id) {
        try {
            return (GreycatNode)this.nodeCache.get((Object)new NodeKey(world, time, id), () -> {
                CompletableFuture result = new CompletableFuture();
                this.graph.lookup(world, time, id, node -> {
                    boolean bl = result.complete(node);
                });
                Node node2 = (Node)result.join();
                return new GreycatNode(this, world, time, id, node2);
            });
        }
        catch (ExecutionException e) {
            LOGGER.error(String.format("Failed to lookup node %d:%d:%d", world, time, id), (Throwable)e);
            return null;
        }
    }

    protected static final class NodeKey {
        public final long world;
        public final long time;
        public final long id;

        public NodeKey(long world, long time, long id) {
            this.world = world;
            this.time = time;
            this.id = id;
        }

        public NodeKey(GreycatNode gn) {
            this(gn.getWorld(), gn.getTime(), gn.getId());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (int)(this.time ^ this.time >>> 32);
            result = 31 * result + (int)(this.world ^ this.world >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeKey other = (NodeKey)obj;
            if (this.id != other.id) {
                return false;
            }
            if (this.time != other.time) {
                return false;
            }
            return this.world == other.world;
        }
    }
}

