/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.junit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;

public abstract class WorkspaceTestCase
extends TestCase {
    public WorkspaceTestCase() {
    }

    public WorkspaceTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setAutoBuilding(false);
        this.cleanUpWorkspace();
    }

    protected void tearDown() throws Exception {
        try {
            this.cleanUpWorkspace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        super.tearDown();
    }

    protected final IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected final IWorkspaceRoot getWorkspaceRoot() {
        return this.getWorkspace().getRoot();
    }

    protected final IProject getProject(String name) {
        return this.getWorkspaceRoot().getProject(name);
    }

    protected final IProject setUpProject(String name) throws CoreException, IOException {
        File sourceRoot;
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("workspace");
        WorkspaceTestCase.assertNotNull((Object)url);
        URL fileURL = FileLocator.toFileURL((URL)url);
        try {
            sourceRoot = new File(fileURL.toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        WorkspaceTestCase.assertNotNull((Object)sourceRoot);
        File source = new File(sourceRoot, name);
        WorkspaceTestCase.assertTrue((boolean)source.exists());
        File targetRoot = this.getWorkspaceRoot().getLocation().toFile();
        File target = new File(targetRoot, name);
        WorkspaceTestCase.copy(source, target);
        IProject project = this.getProject(name);
        this.getWorkspace().run(monitor -> {
            project.create(null);
            project.open(null);
        }, null);
        return project;
    }

    protected final void setAutoBuilding(boolean value) throws CoreException {
        IWorkspaceDescription description = this.getWorkspace().getDescription();
        if (value ^ description.isAutoBuilding()) {
            description.setAutoBuilding(value);
            this.getWorkspace().setDescription(description);
        }
    }

    protected final void buildWorkspace() throws CoreException {
        this.getWorkspace().build(10, null);
        this.waitForBuildCompletion();
    }

    protected final void waitForBuildCompletion() {
        boolean wasInterrupted;
        do {
            wasInterrupted = false;
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    protected final void cleanUpWorkspace() throws CoreException {
        this.getWorkspaceRoot().delete(4, null);
    }

    protected final void suspendJobs() {
        IJobManager jobManager = Job.getJobManager();
        jobManager.suspend();
        jobManager.sleep(null);
        WorkspaceTestCase.join(jobManager);
    }

    private static void join(IJobManager jobManager) {
        Job[] jobs;
        Job[] jobArray = jobs = jobManager.find(null);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (job.shouldSchedule()) {
                boolean wasInterrupted;
                do {
                    wasInterrupted = false;
                    try {
                        job.join();
                    }
                    catch (InterruptedException e) {
                        wasInterrupted = true;
                    }
                } while (wasInterrupted);
            }
            ++n2;
        }
    }

    protected final void resumeJobs() {
        IJobManager jobManager = Job.getJobManager();
        jobManager.resume();
        jobManager.wakeUp(null);
    }

    private static void copy(File source, File dest) throws IOException {
        if (!source.exists()) {
            return;
        }
        if (!dest.exists() && !dest.mkdirs()) {
            throw new IOException("Could not create directory " + String.valueOf(dest));
        }
        if (source.isDirectory()) {
            String[] files = source.list();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    String file = files[i];
                    File sourceFile = new File(source, file);
                    if (sourceFile.isDirectory()) {
                        File destSubDir = new File(dest, file);
                        WorkspaceTestCase.copy(sourceFile, destSubDir);
                    } else {
                        WorkspaceTestCase.copy(sourceFile, dest);
                    }
                    ++i;
                }
            }
        } else {
            File destFile = new File(dest, source.getName());
            if (!destFile.createNewFile()) {
                throw new IOException(String.valueOf(destFile) + " already exists");
            }
            try (FileInputStream inStream = new FileInputStream(source);){
                FileChannel in = inStream.getChannel();
                try (FileOutputStream outStream = new FileOutputStream(destFile);){
                    FileChannel out = outStream.getChannel();
                    out.transferFrom(in, 0L, in.size());
                }
            }
        }
    }
}

