/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.handly.snapshot.Snapshot;

abstract class TextFileSnapshotBase
extends Snapshot {
    static final TextFileSnapshotBase NON_EXISTING = new TextFileSnapshotBase(){

        @Override
        public String getContents() {
            return "";
        }

        @Override
        public IStatus getStatus() {
            return Status.OK_STATUS;
        }

        @Override
        public boolean exists() {
            return false;
        }
    };
    private static final int DEFAULT_READING_SIZE = 8192;
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];

    TextFileSnapshotBase() {
    }

    public abstract IStatus getStatus();

    public abstract boolean exists();

    static String getCharset(InputStream contents, String fileName) throws IOException {
        IContentDescription description = Platform.getContentTypeManager().getDescriptionFor(contents, fileName, new QualifiedName[]{IContentDescription.CHARSET});
        if (description != null) {
            return description.getCharset();
        }
        return null;
    }

    static char[] getInputStreamAsCharArray(InputStream stream, InputStreamReader reader) throws IOException {
        char[] contents = EMPTY_CHAR_ARRAY;
        int contentsLength = 0;
        int amountRead = -1;
        do {
            int amountRequested;
            if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                char[] cArray = contents;
                contents = new char[contentsLength + amountRequested];
                System.arraycopy(cArray, 0, contents, 0, contentsLength);
            }
            if ((amountRead = reader.read(contents, contentsLength, amountRequested)) <= 0) continue;
            contentsLength += amountRead;
        } while (amountRead != -1);
        int start = 0;
        if (contentsLength > 0 && "UTF8".equals(reader.getEncoding()) && contents[0] == '\ufeff') {
            --contentsLength;
            start = 1;
        }
        if (contentsLength < contents.length) {
            char[] cArray = contents;
            contents = new char[contentsLength];
            System.arraycopy(cArray, start, contents, 0, contentsLength);
        }
        return contents;
    }
}

