/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.quickoutline;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.adapter.IContentAdapter;
import org.eclipse.handly.model.adapter.IContentAdapterProvider;
import org.eclipse.handly.model.adapter.NullContentAdapter;
import org.eclipse.handly.ui.IInputElementProvider;
import org.eclipse.handly.ui.quickoutline.FilteringOutlinePopup;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;

public abstract class HandlyOutlinePopup
extends FilteringOutlinePopup
implements IContentAdapterProvider {
    public IContentAdapter getContentAdapter() {
        return NullContentAdapter.INSTANCE;
    }

    @Override
    protected Object computeInput() {
        IElement inputElement = this.getInputElementProvider().getElement(this.getHost().getEditorInput());
        return this.getContentAdapter().getCorrespondingElement(inputElement);
    }

    @Override
    protected Object getCorrespondingElement(ISelection hostSelection) {
        if (!(hostSelection instanceof ITextSelection)) {
            return null;
        }
        IElement input = this.getContentAdapter().adapt(this.getTreeViewer().getInput());
        if (!(input instanceof ISourceElement)) {
            return null;
        }
        ISourceElement[] result = new ISourceElement[1];
        Activator.timedExec("HandlyOutlinePopup::getCorrespondingElement", monitor -> {
            iSourceElementArray[0] = HandlyOutlinePopup.getSourceElementAt((ISourceElement)input, ((ITextSelection)hostSelection).getOffset(), monitor);
        }, 500L);
        return this.getContentAdapter().getCorrespondingElement((IElement)result[0]);
    }

    private static ISourceElement getSourceElementAt(ISourceElement element, int offset, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (!Elements.ensureReconciled((ISourceElement)element, (IProgressMonitor)subMonitor.split(1))) {
            return null;
        }
        try {
            return Elements.getSourceElementAt((ISourceElement)element, (int)offset, (IContext)Contexts.EMPTY_CONTEXT, (IProgressMonitor)subMonitor.split(1));
        }
        catch (CoreException e) {
            if (Elements.exists((IElement)element)) {
                Activator.logError(e);
            }
            return null;
        }
    }

    @Override
    protected boolean revealInHost(Object outlineElement) {
        IElement element = this.getContentAdapter().adapt(outlineElement);
        if (!(element instanceof ISourceElement)) {
            return false;
        }
        ISourceElement sourceElement = (ISourceElement)element;
        if (!this.isInHost((IElement)sourceElement)) {
            return false;
        }
        TextRange identifyingRange = Elements.getSourceElementInfo2((ISourceElement)sourceElement).getIdentifyingRange();
        if (identifyingRange == null) {
            return false;
        }
        TextSelection textSelection = new TextSelection(identifyingRange.getOffset(), identifyingRange.getLength());
        this.getHost().getSelectionProvider().setSelection((ISelection)textSelection);
        return true;
    }

    protected boolean isInHost(IElement element) {
        IElement inputElement = this.getInputElementProvider().getElement(this.getHost().getEditorInput());
        return inputElement != null && Elements.isAncestorOf((IElement)inputElement, (IElement)element);
    }

    protected abstract IInputElementProvider getInputElementProvider();
}

