/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.outline;

import org.eclipse.handly.ui.outline.ICommonOutlinePage;
import org.eclipse.handly.ui.outline.OutlineContribution;
import org.eclipse.handly.ui.preference.IBooleanPreference;
import org.eclipse.handly.ui.preference.IPreferenceListener;
import org.eclipse.handly.ui.preference.PreferenceChangeEvent;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PlatformUI;

public abstract class LinkWithEditorContribution
extends OutlineContribution {
    private OpenAndLinkWithEditorHelper linkingHelper;
    private IBooleanPreference preference;
    private IPreferenceListener preferenceListener = new IPreferenceListener(){

        @Override
        public void preferenceChanged(PreferenceChangeEvent event) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (LinkWithEditorContribution.this.linkingHelper != null && LinkWithEditorContribution.this.preference != null) {
                        LinkWithEditorContribution.this.linkingHelper.setLinkWithEditor(LinkWithEditorContribution.this.preference.getValue());
                    }
                }
            });
        }
    };

    @Override
    public void init(ICommonOutlinePage outlinePage) {
        super.init(outlinePage);
        this.preference = outlinePage.getLinkWithEditorPreference();
        if (this.preference != null) {
            this.linkingHelper = this.getLinkingHelper();
            this.linkingHelper.setLinkWithEditor(this.preference.getValue());
            this.preference.addListener(this.preferenceListener);
        }
    }

    @Override
    public void dispose() {
        if (this.preference != null) {
            this.preference.removeListener(this.preferenceListener);
            this.preference = null;
        }
        if (this.linkingHelper != null) {
            this.linkingHelper.dispose();
            this.linkingHelper = null;
        }
        super.dispose();
    }

    protected abstract OpenAndLinkWithEditorHelper getLinkingHelper();
}

