/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import java.lang.reflect.Field;

public class EObjectExclusionStrategy
implements ExclusionStrategy {
    private static final String EPACKAGE_NS = "org.eclipse.emf.ecore";
    private static final int EXCLUDED_MODIFIERS = 136;

    public boolean shouldSkipField(FieldAttributes f) {
        return f.getDeclaringClass().getPackage().getName().startsWith(EPACKAGE_NS);
    }

    public boolean shouldSkipClass(Class<?> clazz) {
        return false;
    }

    public static boolean excludeField(Field field) {
        if ((0x88 & field.getModifiers()) != 0) {
            return true;
        }
        if (field.isSynthetic()) {
            return true;
        }
        if (EObjectExclusionStrategy.isInnerClass(field.getType())) {
            return true;
        }
        if (EObjectExclusionStrategy.isAnonymousOrNonStaticLocal(field.getType())) {
            return true;
        }
        FieldAttributes attributes = new FieldAttributes(field);
        return new EObjectExclusionStrategy().shouldSkipField(attributes);
    }

    private static boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !EObjectExclusionStrategy.isStatic(clazz);
    }

    private static boolean isStatic(Class<?> clazz) {
        return (clazz.getModifiers() & 8) != 0;
    }

    private static boolean isAnonymousOrNonStaticLocal(Class<?> clazz) {
        return !Enum.class.isAssignableFrom(clazz) && !EObjectExclusionStrategy.isStatic(clazz) && (clazz.isAnonymousClass() || clazz.isLocalClass());
    }
}

