/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.gmodel;

import com.google.inject.Inject;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.emf.common.command.Command;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.actions.SelectAction;
import org.eclipse.glsp.server.gmodel.GModelCreateOperationHandler;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.CreateNodeOperation;
import org.eclipse.glsp.server.utils.LayoutUtil;

public abstract class GModelCreateNodeOperationHandler
extends GModelCreateOperationHandler<CreateNodeOperation> {
    @Inject
    protected ActionDispatcher actionDispatcher;

    public GModelCreateNodeOperationHandler(String ... elementTypeIds) {
        super(elementTypeIds);
    }

    public GModelCreateNodeOperationHandler(List<String> handledElementTypeIds) {
        super(handledElementTypeIds);
    }

    @Override
    public Optional<Command> createCommand(CreateNodeOperation operation) {
        return this.commandOf(() -> this.executeCreation(operation));
    }

    public void executeCreation(CreateNodeOperation operation) {
        GModelElement container = this.getContainer(operation).orElseGet((Supplier<GModelElement>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getRoot(), ()Lorg/eclipse/glsp/graph/GModelElement;)((GModelState)this.modelState));
        Optional<GPoint> absoluteLocation = this.getLocation(operation);
        Optional<GPoint> relativeLocation = this.getRelativeLocation(container, absoluteLocation);
        GNode element = this.createNode(relativeLocation, operation.getArgs());
        container.getChildren().add((Object)element);
        this.actionDispatcher.dispatchAfterNextUpdate(SelectAction.addSelection(List.of(element.getId())));
    }

    protected Optional<GPoint> getLocation(CreateNodeOperation operation) {
        return operation.getLocation();
    }

    protected Optional<GPoint> getRelativeLocation(GModelElement container, Optional<GPoint> absoluteLocation) {
        return absoluteLocation.map(location -> LayoutUtil.getRelativeLocation(location, container));
    }

    protected Optional<GModelElement> getContainer(CreateNodeOperation operation) {
        return this.modelState.getIndex().get(operation.getContainerId());
    }

    protected abstract GNode createNode(Optional<GPoint> var1, Map<String, String> var2);
}

