/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.taskedit;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.glsp.example.workflow.taskedit.EditTaskOperation;
import org.eclipse.glsp.example.workflow.wfgraph.TaskNode;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.features.contextactions.ContextActionsProvider;
import org.eclipse.glsp.server.features.contextactions.SetAutoCompleteValueAction;
import org.eclipse.glsp.server.features.directediting.LabeledAction;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.types.EditorContext;

public class TaskEditContextActionProvider
implements ContextActionsProvider {
    public static final String DURATION_PREFIX = "duration:";
    public static final String TYPE_PREFIX = "type:";
    public static final String TASK_PREFIX = "task:";

    public String getContextId() {
        return "task-editor";
    }

    public List<? extends LabeledAction> getActions(EditorContext editorContext, GModelState modelState) {
        String text = editorContext.getArgs().getOrDefault("text", "");
        Optional taskNode = modelState.getIndex().findElementByClass((String)editorContext.getSelectedElementIds().get(0), TaskNode.class);
        if (taskNode.isEmpty()) {
            return Collections.emptyList();
        }
        if (text.startsWith(TYPE_PREFIX)) {
            String id = ((TaskNode)taskNode.get()).getId();
            return Lists.newArrayList((Object[])new LabeledAction[]{new LabeledAction("type:automated", (List)Lists.newArrayList((Object[])new Action[]{new EditTaskOperation(id, "taskType", "automated")})), new LabeledAction("type:manual", (List)Lists.newArrayList((Object[])new Action[]{new EditTaskOperation(id, "taskType", "manual")}))});
        }
        if (text.startsWith(DURATION_PREFIX)) {
            return Collections.emptyList();
        }
        String taskType = ((TaskNode)taskNode.get()).getType().substring(TASK_PREFIX.length());
        int duration = ((TaskNode)taskNode.get()).getDuration();
        return Lists.newArrayList((Object[])new SetAutoCompleteValueAction[]{new SetAutoCompleteValueAction(TYPE_PREFIX, "", TYPE_PREFIX + taskType), new SetAutoCompleteValueAction(DURATION_PREFIX, "", DURATION_PREFIX + duration)});
    }
}

