/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.ui;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramComposite;
import org.eclipse.glsp.ide.editor.ui.GLSPIdeEditorPlugin;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.SaveModelAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;

public abstract class GLSPDiagramPart {
    protected final GLSPDiagramComposite diagram;
    @Inject
    protected MPart part;

    protected GLSPDiagramPart(String glspEditorId) {
        this.diagram = new GLSPDiagramComposite(glspEditorId);
        GLSPIdeEditorPlugin.getDefault().getGLSPEditorRegistry().registerComposite(this.diagram);
    }

    @PostConstruct
    public void createContent(Composite composite, IEclipseContext context, ESelectionService selectionService, EHandlerService handlerService, EMenuService menuService) {
        this.diagram.init(context, this.getInput());
        this.diagram.addDirtyStateListener(this::setDirty);
        this.diagram.createPartControl(composite);
        this.diagram.addSelectionChangedListener(event -> selectionService.setSelection((Object)this.diagram.getSelection()));
        this.initilizeCommands(context, handlerService);
        this.registerContextMenu(menuService);
    }

    protected boolean registerContextMenu(EMenuService menuService) {
        for (MMenu menu : this.part.getMenus()) {
            if (!(menu instanceof MPopupMenu)) continue;
            return menuService.registerContextMenu((Object)this.diagram.getBrowser(), menu.getElementId());
        }
        return false;
    }

    protected void initilizeCommands(IEclipseContext context, EHandlerService handlerService) {
        for (Map.Entry<String, IAction> action : this.diagram.getGlobalActions().entrySet()) {
            IActionCommandMappingService commandMappingService = (IActionCommandMappingService)context.get(IActionCommandMappingService.class);
            String commandId = commandMappingService.getCommandId(action.getKey());
            handlerService.activateHandler(commandId, (Object)new Handler(action.getValue()));
        }
    }

    protected abstract String getInput();

    protected void setDirty(boolean dirty) {
        this.part.setDirty(dirty);
    }

    @Focus
    public void focus() {
        this.diagram.setFocus();
    }

    @PreDestroy
    public void preDestroy() {
        this.diagram.notifyAboutToBeDisposed();
        this.diagram.dispose();
    }

    @Persist
    public void save() {
        this.diagram.dispatch((Action)new SaveModelAction());
    }

    public MPart getPart() {
        return this.part;
    }

    protected static class Handler {
        private final IAction value;

        Handler(IAction value) {
            this.value = value;
        }

        @Execute
        public void execute() {
            this.value.run();
        }
    }
}

