/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.impl.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.ElementNotFoundException;
import org.eclipse.gendoc.services.exception.ModelNotFoundException;
import org.eclipse.gendoc.tags.handlers.IContextService;
import org.eclipse.gendoc.tags.handlers.IEMFModelLoaderService;

public class ContextService
extends AbstractService
implements IContextService {
    protected static URIConverter uriConverter = new ExtensibleURIConverterImpl(ContextService.getURIHandlers(), (Collection)ContentHandler.Registry.INSTANCE.contentHandlers());
    private static final String ELEMENT_DEFAULT_PATH = "{0}";
    private static String delimiter = "\\s*;\\s*";
    private URI model;
    private String elementPath = "{0}";
    private EObject element;
    private final List<String> importedBundles = new LinkedList<String>();
    private String featureLabel = "name";
    private boolean searchMetamodels = false;

    protected static List<URIHandler> getURIHandlers() {
        ArrayList<URIHandler> l = new ArrayList<URIHandler>();
        for (URIHandler uriHandler : URIHandler.DEFAULT_HANDLERS) {
            if (uriHandler.getClass() == URIHandlerImpl.class) continue;
            l.add(uriHandler);
        }
        return l;
    }

    public void clear() {
        this.importedBundles.clear();
    }

    @Override
    public EObject getModel() throws ModelNotFoundException {
        IEMFModelLoaderService modelLoader = (IEMFModelLoaderService)GendocServices.getDefault().getService(IEMFModelLoaderService.class);
        return modelLoader.getModel(this.model);
    }

    @Override
    public String getModelPath() {
        return this.model.toString();
    }

    @Override
    public boolean isSearchMetamodels() {
        return this.searchMetamodels;
    }

    @Override
    public void setModel(String modelPath) throws ModelNotFoundException {
        try {
            try {
                this.model = URI.createURI((String)modelPath);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (!this.isValid(this.model)) {
                this.model = URI.createFileURI((String)modelPath);
            }
            this.element = null;
            this.elementPath = ELEMENT_DEFAULT_PATH;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ModelNotFoundException(modelPath);
        }
    }

    protected boolean isValid(URI uri) {
        if (uri != null) {
            Object f;
            if (uri.scheme() == null || "".equals(uri.scheme())) {
                return false;
            }
            for (URIHandler handler : uriConverter.getURIHandlers()) {
                if (!handler.canHandle(uri)) continue;
                return true;
            }
            if (uri.scheme() != null && (f = Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap().get(uri.scheme())) != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public EObject getElement() throws ModelNotFoundException, ElementNotFoundException {
        if (this.element == null) {
            IEMFModelLoaderService modelLoader = (IEMFModelLoaderService)GendocServices.getDefault().getService(IEMFModelLoaderService.class);
            this.element = modelLoader.getCurrentElement(this.elementPath, this.getModel(), 1, this.featureLabel);
        }
        return this.element;
    }

    @Override
    public void setElementPath(String elementPath) {
        this.elementPath = elementPath;
        this.element = null;
    }

    @Override
    public List<String> getImportedBundles() {
        return this.importedBundles;
    }

    @Override
    public void setFeatureLabel(String featureLabel) {
        this.featureLabel = featureLabel;
    }

    @Override
    public void setSearchMetamodels(boolean searchMetamodels) {
        this.searchMetamodels = searchMetamodels;
    }

    @Override
    public void setImportedBundles(String attributesBundles) {
        String[] bundles;
        this.importedBundles.clear();
        String[] stringArray = bundles = attributesBundles.trim().split(delimiter);
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            String bundle = stringArray[n2];
            this.importedBundles.add(bundle);
            ++n2;
        }
    }
}

