/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.papyrus.service;

import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gendoc.tags.handlers.impl.context.EMFModelLoaderService;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelIdentifiers;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;

public class PapyrusModelLoaderService
extends EMFModelLoaderService {
    URI modelURI;

    public PapyrusModelLoaderService(URI modelUri) {
        this.modelURI = modelUri;
    }

    protected ResourceSet constructResourceSet() {
        if (this.resourceSet == null) {
            try {
                this.resourceSet = this.getPapyrusModelSet(this.modelURI);
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        if (this.resourceSet == null) {
            this.resourceSet = super.constructResourceSet();
        }
        return this.resourceSet;
    }

    protected Resource getResource(URI uri) {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet.getResource(uri, false) != null) {
            return resourceSet.getResource(uri, false);
        }
        if (resourceSet instanceof ModelSet) {
            String modelId;
            ModelSet modelSet = (ModelSet)resourceSet;
            String ext = uri.fileExtension();
            String fileName = uri.toFileString();
            IFile file = null;
            if (fileName != null) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
            } else if (uri.toString().startsWith("platform:/resource")) {
                String path = uri.toString().substring("platform:/resource".length());
                IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                if (workspaceResource instanceof IFile) {
                    file = (IFile)workspaceResource;
                }
            }
            if (file != null && (modelId = this.getModelId(ext)) != null) {
                try {
                    modelSet = this.getPapyrusModelSet(uri);
                    IModel model = modelSet.getModel(modelId);
                    return ((AbstractBaseModel)model).getResource();
                }
                catch (ServiceException e) {
                    Activator.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return super.getResource(uri);
    }

    private ModelSet getPapyrusModelSet(URI modelUri) throws ServiceException {
        ModelSet modelSet = null;
        ExtensionServicesRegistry servicesRegistry = new ExtensionServicesRegistry("org.eclipse.papyrus.infra.core");
        try {
            servicesRegistry.startServices(Collections.singletonList(ModelSet.class.getName()));
            modelSet = (ModelSet)servicesRegistry.getService(ModelSet.class);
            if (modelSet != null && modelUri != null) {
                modelSet.loadModels(modelUri);
            }
            servicesRegistry.startRegistry();
        }
        catch (ModelMultiException modelMultiException) {
            try {
                servicesRegistry.startRegistry();
            }
            catch (ServiceException serviceException) {}
        }
        catch (ServiceException serviceException) {}
        return modelSet;
    }

    protected ModelIdentifiers getModelIdsToImport(String modelId) {
        if ("org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel".equals(modelId) || "org.eclipse.papyrus.infra.core.resource.notation.NotationModel".equals(modelId) || "org.eclipse.papyrus.infra.core.resource.uml.UmlModel".equals(modelId)) {
            return new ModelIdentifiers(new String[]{"org.eclipse.papyrus.infra.core.resource.notation.NotationModel", "org.eclipse.papyrus.infra.core.resource.uml.UmlModel"});
        }
        return new ModelIdentifiers(new String[]{modelId});
    }

    protected String getModelId(String ext) {
        if ("di".equals(ext)) {
            return "org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel";
        }
        if ("notation".equals(ext)) {
            return "org.eclipse.papyrus.infra.core.resource.notation.NotationModel";
        }
        if ("uml".equals(ext)) {
            return "org.eclipse.papyrus.infra.core.resource.uml.UmlModel";
        }
        return "org.eclipse.papyrus.resource.additional";
    }
}

