/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.impl.context;

import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.exception.InvalidTemplateParameterException;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.handlers.IConfigurationService;
import org.eclipse.gendoc.tags.handlers.IContextService;
import org.eclipse.gendoc.tags.handlers.impl.AbstractServicesTagHandler;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;

public class ContextTagHandler
extends AbstractServicesTagHandler {
    public String doRun(ITag tag) throws GenDocException {
        super.doRun(tag);
        return "";
    }

    protected String runAttributes(ITag tag, String value) throws GenDocException {
        super.runAttributes(tag, value);
        IContextService contextService = (IContextService)GendocServices.getDefault().getService(IContextService.class);
        for (String key : tag.getAttributes().keySet()) {
            if (!RegisteredTags.CONTEXT_MODEL.equalsIgnoreCase(key)) continue;
            String modelPath = this.replaceParameters((String)tag.getAttributes().get(key));
            contextService.setModel(modelPath.replaceAll("\\\\", "/"));
        }
        for (String key : tag.getAttributes().keySet()) {
            if (RegisteredTags.CONTEXT_ELEMENT.equalsIgnoreCase(key)) {
                String elementPath = this.replaceParameters((String)tag.getAttributes().get(key));
                contextService.setElementPath(elementPath);
            }
            if (RegisteredTags.CONTEXT_FEATURE_LABEL.equalsIgnoreCase(key)) {
                contextService.setFeatureLabel((String)tag.getAttributes().get(key));
            }
            if (RegisteredTags.CONTEXT_IMPORTED_BUNDLES.equalsIgnoreCase(key)) {
                contextService.setImportedBundles((String)tag.getAttributes().get(key));
            }
            if (!RegisteredTags.CONTEXT_SEARCH_METAMODELS.equalsIgnoreCase(key)) continue;
            contextService.setSearchMetamodels(Boolean.parseBoolean((String)tag.getAttributes().get(key)));
        }
        return value;
    }

    private String replaceParameters(String path) throws InvalidTemplateParameterException {
        IConfigurationService configService = (IConfigurationService)GendocServices.getDefault().getService(IConfigurationService.class);
        return configService.replaceParameters(path);
    }
}

