/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class LimitLatch {
    private final Sync sync;
    private final AtomicLong count;
    private volatile long limit;
    private volatile boolean released = false;

    public LimitLatch(long limit) {
        this.limit = limit;
        this.count = new AtomicLong(0L);
        this.sync = new Sync();
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void countUpOrAwait() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public long countDown() {
        this.sync.releaseShared(0);
        return this.count.get();
    }

    public boolean releaseAll() {
        this.released = true;
        return this.sync.releaseShared(0);
    }

    public void reset() {
        this.count.set(0L);
        this.released = false;
    }

    public boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public Collection<Thread> getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    private class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1L;

        @Override
        protected int tryAcquireShared(int ignored) {
            long newCount = LimitLatch.this.count.incrementAndGet();
            if (!LimitLatch.this.released && newCount > LimitLatch.this.limit) {
                LimitLatch.this.count.decrementAndGet();
                return -1;
            }
            return 1;
        }

        @Override
        protected boolean tryReleaseShared(int arg) {
            LimitLatch.this.count.decrementAndGet();
            return true;
        }
    }
}

