/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.framework.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.eclipse.gemini.management.internal.BundleUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.jmx.framework.BundleStateMBean;

public final class OSGiBundle {
    private Bundle bundle;

    public OSGiBundle(Bundle b) {
        this.bundle = b;
    }

    public static TabularData tableFrom(List<OSGiBundle> bundles, String ... bundleTypeItems) throws IOException {
        List<String> bundleTypes = Arrays.asList(bundleTypeItems);
        TabularDataSupport table = new TabularDataSupport(BundleStateMBean.BUNDLES_TYPE);
        for (OSGiBundle bundle : bundles) {
            table.put(bundle.asCompositeData(bundleTypes));
        }
        return table;
    }

    private CompositeData asCompositeData(List<String> bundleTypes) throws IOException {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Identifier", this.getIdentifier());
        items.put("Location", bundleTypes.contains("Location") ? this.getLocation() : null);
        items.put("SymbolicName", bundleTypes.contains("SymbolicName") ? this.getSymbolicName() : null);
        items.put("Version", bundleTypes.contains("Version") ? this.getVersion() : null);
        items.put("StartLevel", bundleTypes.contains("StartLevel") ? Integer.valueOf(this.getStartLevel()) : null);
        items.put("State", bundleTypes.contains("State") ? this.getState() : null);
        items.put("LastModified", bundleTypes.contains("LastModified") ? Long.valueOf(this.getLastModified()) : null);
        items.put("PersistentlyStarted", bundleTypes.contains("PersistentlyStarted") ? Boolean.valueOf(this.isPersistentlyStarted()) : null);
        items.put("ActivationPolicyUsed", bundleTypes.contains("ActivationPolicyUsed") ? Boolean.valueOf(this.isActivationPolicyUsed()) : null);
        items.put("RemovalPending", bundleTypes.contains("RemovalPending") ? Boolean.valueOf(this.isRemovalPending()) : null);
        items.put("Required", bundleTypes.contains("Required") ? Boolean.valueOf(this.isRequired()) : null);
        items.put("Fragment", bundleTypes.contains("Fragment") ? Boolean.valueOf(this.isFragment()) : null);
        items.put("RegisteredServices", bundleTypes.contains("RegisteredServices") ? this.getRegisteredServices() : null);
        items.put("ServicesInUse", bundleTypes.contains("ServicesInUse") ? this.getServicesInUse() : null);
        items.put("Headers", bundleTypes.contains("Headers") ? this.getHeaders() : null);
        items.put("ExportedPackages", bundleTypes.contains("ExportedPackages") ? this.getExportedPackages() : null);
        items.put("ImportedPackages", bundleTypes.contains("ImportedPackages") ? this.getImportedPackages() : null);
        items.put("Fragments", bundleTypes.contains("Fragments") ? this.getFragments() : null);
        items.put("Hosts", bundleTypes.contains("Hosts") ? this.getHosts() : null);
        items.put("RequiringBundles", bundleTypes.contains("RequiringBundles") ? this.getRequiringBundles() : null);
        items.put("RequiredBundles", bundleTypes.contains("RequiredBundles") ? this.getRequiredBundles() : null);
        try {
            return new CompositeDataSupport(BundleStateMBean.BUNDLE_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle open data", e);
        }
    }

    public CompositeData asCompositeData() throws IOException {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Identifier", this.getIdentifier());
        items.put("Location", this.getLocation());
        items.put("SymbolicName", this.getSymbolicName());
        items.put("Version", this.getVersion());
        items.put("StartLevel", this.getStartLevel());
        items.put("State", this.getState());
        items.put("LastModified", this.getLastModified());
        items.put("PersistentlyStarted", this.isPersistentlyStarted());
        items.put("ActivationPolicyUsed", this.isActivationPolicyUsed());
        items.put("RemovalPending", this.isRemovalPending());
        items.put("Required", this.isRequired());
        items.put("Fragment", this.isFragment());
        items.put("RegisteredServices", this.getRegisteredServices());
        items.put("ServicesInUse", this.getServicesInUse());
        items.put("Headers", OSGiBundle.headerTable(this.getHeaders()));
        items.put("ExportedPackages", this.getExportedPackages());
        items.put("ImportedPackages", this.getImportedPackages());
        items.put("Fragments", this.getFragments());
        items.put("Hosts", this.getHosts());
        items.put("RequiringBundles", this.getRequiringBundles());
        items.put("RequiredBundles", this.getRequiredBundles());
        try {
            return new CompositeDataSupport(BundleStateMBean.BUNDLE_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle open data", e);
        }
    }

    public static TabularData headerTable(Dictionary<String, String> headersDictionary) {
        TabularDataSupport table = new TabularDataSupport(BundleStateMBean.HEADERS_TYPE);
        Enumeration<String> headers = headersDictionary.keys();
        while (headers.hasMoreElements()) {
            String key = headers.nextElement();
            table.put(OSGiBundle.getHeaderCompositeData(key, headersDictionary.get(key)));
        }
        return table;
    }

    private static CompositeData getHeaderCompositeData(String key, String value) {
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("Key", key);
        items.put("Value", value);
        try {
            return new CompositeDataSupport(BundleStateMBean.HEADER_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle header open data", e);
        }
    }

    private String[] getExportedPackages() {
        return BundleUtil.getBundleExportedPackages(this.bundle);
    }

    private Dictionary<String, String> getHeaders() {
        return this.bundle.getHeaders();
    }

    private Long[] getFragments() {
        BundleWiring wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
        List requiredWires = wiring.getRequiredWires("osgi.wiring.host");
        return OSGiBundle.bundleWiresToProviderIds(requiredWires);
    }

    private Long[] getHosts() {
        BundleWiring wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
        List providedWires = wiring.getProvidedWires("osgi.wiring.host");
        return OSGiBundle.bundleWiresToRequirerIds(providedWires);
    }

    private long getIdentifier() {
        return this.bundle.getBundleId();
    }

    private String[] getImportedPackages() {
        return BundleUtil.getBundleImportedPackages(this.bundle);
    }

    private long getLastModified() {
        return this.bundle.getLastModified();
    }

    private String getLocation() {
        return this.bundle.getLocation();
    }

    private Long[] getRegisteredServices() {
        return OSGiBundle.serviceIds(this.bundle.getRegisteredServices());
    }

    private Long[] getRequiredBundles() throws IOException {
        return BundleUtil.getRequiredBundles(this.bundle);
    }

    private Long[] getRequiringBundles() throws IOException {
        return BundleUtil.getRequiringBundles(this.bundle);
    }

    private Long[] getServicesInUse() {
        return OSGiBundle.serviceIds(this.bundle.getServicesInUse());
    }

    private int getStartLevel() {
        return BundleUtil.getBundleStartLevel(this.bundle);
    }

    private String getState() {
        return BundleUtil.getBundleState(this.bundle);
    }

    private String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    private String getVersion() {
        return this.bundle.getVersion().toString();
    }

    private boolean isFragment() {
        return BundleUtil.isBundleFragment(this.bundle);
    }

    private boolean isPersistentlyStarted() {
        return BundleUtil.isBundlePersistentlyStarted(this.bundle);
    }

    private boolean isActivationPolicyUsed() {
        return BundleUtil.isBundleActivationPolicyUsed(this.bundle);
    }

    private boolean isRemovalPending() {
        return BundleUtil.isRemovalPending(this.bundle);
    }

    private boolean isRequired() {
        return BundleUtil.isRequired(this.bundle);
    }

    public static Long[] bundleWiresToRequirerIds(List<BundleWire> wires) {
        Long[] requirerIds = new Long[wires.size()];
        int i = 0;
        for (BundleWire bundleWire : wires) {
            requirerIds[i] = bundleWire.getRequirerWiring().getBundle().getBundleId();
            ++i;
        }
        return requirerIds;
    }

    public static Long[] bundleWiresToProviderIds(List<BundleWire> wires) {
        Long[] providerIds = new Long[wires.size()];
        int i = 0;
        for (BundleWire bundleWire : wires) {
            providerIds[i] = bundleWire.getProviderWiring().getBundle().getBundleId();
            ++i;
        }
        return providerIds;
    }

    public static Long[] serviceIds(ServiceReference<?>[] refs) {
        if (refs == null) {
            return new Long[0];
        }
        ArrayList<Long> idsList = new ArrayList<Long>();
        int i = 0;
        while (i < refs.length) {
            Object serviceIdProperty = refs[i].getProperty("service.id");
            if (serviceIdProperty != null) {
                idsList.add((Long)serviceIdProperty);
            }
            ++i;
        }
        return idsList.toArray(new Long[idsList.size()]);
    }
}

