/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.fsm.generic;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.CPBranchTransition;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.Guard;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FSMExtensions {
    @Inject
    @Extension
    protected FSMHelpers _fSMHelpers;

    public <T> List<T> union(Iterable<T> l, T e) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterables.addAll(ret, l);
        ret.add(e);
        return ret;
    }

    public <T> List<T> union(Iterable<T> l1, Iterable<T> l2) {
        ArrayList ret = new ArrayList();
        Iterables.addAll(ret, l1);
        Iterables.addAll(ret, l2);
        return ret;
    }

    public <T> List<T> minus(List<T> l1, List<T> l2) {
        ArrayList<T> ret = new ArrayList<T>(l1);
        ret.removeAll(l2);
        return ret;
    }

    public List<State> getAllLeafStates(ModelComponent mc) {
        return this._fSMHelpers.getLeafStateList(mc.getStateMachine());
    }

    public List<State> getAllBaseStatesLeavesLast(ModelComponent mc) {
        return IterableExtensions.toList((Iterable)FsmGenExtensions.getLeafStatesLast((List)this._fSMHelpers.getAllBaseStates(mc)));
    }

    public int getNumberOfInheritedStates(ModelComponent mc) {
        boolean bl;
        ModelComponent modelComponent = mc.getBase();
        boolean bl2 = bl = modelComponent == null;
        if (bl) {
            return 0;
        }
        int n = this._fSMHelpers.getStateList(mc.getBase().getStateMachine()).size();
        int n2 = this.getNumberOfInheritedStates(mc.getBase());
        return n + n2;
    }

    public int getNumberOfInheritedBaseStates(ModelComponent ac) {
        boolean bl;
        ModelComponent modelComponent = ac.getBase();
        boolean bl2 = bl = modelComponent == null;
        if (bl) {
            return 0;
        }
        int n = this._fSMHelpers.getBaseStateList(ac.getBase().getStateMachine()).size();
        int n2 = this.getNumberOfInheritedBaseStates(ac.getBase());
        return n + n2;
    }

    public boolean isConditionOrGuard(DetailCode dc) {
        boolean bl = false;
        EObject parent = dc.eContainer();
        boolean bl2 = false;
        boolean bl3 = false;
        if (parent instanceof Guard) {
            bl3 = true;
            bl2 = true;
        }
        if (!bl3 && parent instanceof CPBranchTransition) {
            bl3 = true;
            DetailCode detailCode = ((CPBranchTransition)parent).getCondition();
            bl2 = Objects.equals(detailCode, dc);
        }
        if (!bl3) {
            bl2 = false;
        }
        bl = bl2;
        return bl;
    }
}

