/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.hover.highlight;

import org.eclipse.etrice.core.common.ui.hover.highlight.XtextTokenScanner;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class XtextHtmlHighlighter {
    public static final String HTML_CLASS_HIGHLIGHTEDFLAG = "customHighlighted";
    private XtextTokenScanner scanner;

    public XtextHtmlHighlighter(XtextTokenScanner scanner) {
        this.scanner = scanner;
    }

    public String htmlStartTags() {
        return "<pre><code class=" + this.scanner.getLanguageName() + " customHighlighted>";
    }

    public String highlight(String text) {
        IToken next;
        StringBuilder builder = new StringBuilder(text);
        Document document = new Document(text);
        this.scanner.setRange((IDocument)document, 0, document.getLength());
        int pointer = 0;
        while ((next = this.scanner.nextToken()) != Token.EOF) {
            if (next instanceof XtextTokenScanner.CodeToken) {
                String pre = "<span class=" + String.valueOf(next.getData()) + ">";
                String post = "</span>";
                builder.insert(pointer + this.scanner.getTokenLength(), post);
                builder.insert(pointer, pre);
                pointer += pre.length() + post.length();
            }
            pointer += this.scanner.getTokenLength();
        }
        return builder.toString();
    }

    public String htmlEndTags() {
        return "</code></pre>";
    }
}

