/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.ui.configurator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.etrice.generator.ui.configurator.IProjectConfigurator;

public class ProjectConfigurationDelegator
implements IProjectConfigurator {
    private static final String ICONFIGURATOR_ID = "org.eclipse.etrice.generator.ui.project_configurator";
    private static ProjectConfigurationDelegator instance = null;
    private HashMap<String, ArrayList<IProjectConfigurator>> nature2configurators = new HashMap();

    public static ProjectConfigurationDelegator getInstance() {
        if (instance == null) {
            instance = new ProjectConfigurationDelegator();
        }
        return instance;
    }

    private ProjectConfigurationDelegator() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(ICONFIGURATOR_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object ext = e.createExecutableExtension("class");
                if (ext instanceof IProjectConfigurator) {
                    IProjectConfigurator configurator = (IProjectConfigurator)ext;
                    String nature = e.getAttribute("appliesToNature");
                    this.addConfigurator(nature, configurator);
                }
            }
            catch (CoreException ex) {
                System.out.println(ex.getMessage());
            }
            ++n2;
        }
    }

    private void addConfigurator(String nature, IProjectConfigurator configurator) {
        ArrayList<IProjectConfigurator> configurators = this.nature2configurators.get(nature);
        if (configurators == null) {
            configurators = new ArrayList();
            this.nature2configurators.put(nature, configurators);
        }
        configurators.add(configurator);
    }

    @Override
    public void configure(IProject project, IPath path, boolean copyRuntime, String platform, IProgressMonitor progressMonitor) {
        for (Map.Entry<String, ArrayList<IProjectConfigurator>> entry : this.nature2configurators.entrySet()) {
            try {
                if (!project.hasNature(entry.getKey())) continue;
                for (IProjectConfigurator configurator : entry.getValue()) {
                    configurator.configure(project, path, copyRuntime, platform, progressMonitor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

