/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.contractmonitor.gen;

import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.BaseFactory;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.common.base.util.ImportHelpers;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.FSMFactory;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.StateTerminal;
import org.eclipse.etrice.core.fsm.fSM.TransitionTerminal;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.genmodel.fsm.ExtendedFsmGenBuilder;
import org.eclipse.etrice.core.genmodel.fsm.ExtendedFsmGenBuilderFactory;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.CommonTrigger;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.util.InterfaceContractHelpers;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class MonitorActorGen {
    private static final QualifiedName MONITOR_BASE_FQN = QualifiedName.create((String[])new String[]{"etrice", "api", "contracts", "monitors", "AContractMonitorBase"});
    @Inject
    private BaseFactory baseFactory;
    @Inject
    private RoomFactory roomFactory;
    @Inject
    private FSMFactory fsmFactory;
    @Inject
    private ExtendedFsmGenBuilderFactory fsmGenBuilderFactory;
    @Inject
    private InterfaceContractHelpers helpers;
    @Inject
    private RoomHelpers roomHelpers;
    @Inject
    private ImportHelpers importHelpers;

    public String serializeMonitors(RoomModel generatedMonitors, ResourceSet rs) {
        String string = null;
        String serializedModel = this.serialize(generatedMonitors, rs);
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("(ActorClass\\s+[\\w_]+)\\s*\\{");
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("$1 extends ");
        String string2 = MONITOR_BASE_FQN.toString();
        stringConcatenation2.append(string2);
        stringConcatenation2.append(" {");
        string = serializedModel.replaceAll(stringConcatenation.toString(), stringConcatenation2.toString());
        return string;
    }

    private String serialize(RoomModel model, ResourceSet rs) {
        try {
            String string = null;
            ByteArrayOutputStream oos = new ByteArrayOutputStream();
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("tmp:/");
            String string2 = model.getName();
            stringConcatenation.append(string2);
            stringConcatenation.append(".room");
            Resource res = rs.createResource(URI.createURI((String)stringConcatenation.toString()));
            res.getContents().add((Object)model);
            try {
                try {
                    res.save((OutputStream)oos, null);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof IOException) {
                        IOException e = (IOException)throwable;
                        e.printStackTrace();
                        throw e;
                    }
                    throw Exceptions.sneakyThrow((Throwable)throwable);
                }
            }
            finally {
                rs.getResources().remove((Object)res);
            }
            StringConcatenation stringConcatenation2 = new StringConcatenation();
            stringConcatenation2.append("/** generated */");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
            stringConcatenation2.append((Object)oos);
            stringConcatenation2.newLineIfNotEmpty();
            string = stringConcatenation2.toString();
            return string;
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
    }

    public RoomModel generateMonitors(RoomModel model) {
        RoomModel roomModel = this.roomFactory.createRoomModel();
        Procedures.Procedure1 procedure1 = it -> {
            String string = model.getName();
            String string2 = string + "_monitors";
            it.setName(string2);
            EList eList = it.getImports();
            Functions.Function1 function1 = it_1 -> (Import)EcoreUtil.copy((EObject)it_1);
            List list = ListExtensions.map((List)model.getImports(), (Functions.Function1)function1);
            Iterables.addAll((Collection)eList, (Iterable)list);
            EList eList2 = it.getImports();
            Import import_ = this.baseFactory.createImport();
            Procedures.Procedure1 procedure1 = it_1 -> {
                String string = model.getName();
                String string2 = string + ".*";
                it_1.setImportedNamespace(string2);
            };
            Import import_2 = (Import)ObjectExtensions.operator_doubleArrow((Object)import_, (Procedures.Procedure1)procedure1);
            eList2.add((Object)import_2);
            EList eList3 = it.getRoomClasses();
            Functions.Function1 function12 = it_1 -> this.helpers.isContract(it_1);
            Functions.Function1 function13 = contract -> this.generateMonitor((ActorClass)contract, (ProtocolClass)Verify.verifyNotNull((Object)this.helpers.getContractProtocol(contract)));
            Iterable iterable = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)model.getRoomClasses(), ActorClass.class), (Functions.Function1)function12), (Functions.Function1)function13);
            Iterables.addAll((Collection)eList3, (Iterable)iterable);
        };
        return (RoomModel)ObjectExtensions.operator_doubleArrow((Object)roomModel, (Procedures.Procedure1)procedure1);
    }

    protected ActorClass generateMonitor(ActorClass contract, ProtocolClass contractProtocol) {
        ActorClass actorClass = (ActorClass)EcoreUtil.copy((EObject)contract);
        Procedures.Procedure1 procedure1 = it -> {
            boolean bl;
            it.setName(this.helpers.getGeneratedMonitorName(contract));
            Predicate<Annotation> predicate = it_1 -> {
                String string = it_1.getType().getName();
                return com.google.common.base.Objects.equal((Object)string, (Object)"InterfaceContractDefinition");
            };
            it.getAnnotations().removeIf(predicate);
            ModelComponent modelComponent = it.getBase();
            boolean bl2 = bl = modelComponent == null;
            if (bl) {
                IEObjectDescription iEObjectDescription = this.importHelpers.getVisibleScope(contract.eResource(), RoomPackage.Literals.ACTOR_CLASS).getSingleElement(MONITOR_BASE_FQN);
                EObject eObject = null;
                if (iEObjectDescription != null) {
                    eObject = iEObjectDescription.getEObjectOrProxy();
                }
                it.setBase((ModelComponent)((ActorClass)eObject));
            }
        };
        ActorClass monitor = (ActorClass)ObjectExtensions.operator_doubleArrow((Object)actorClass, (Procedures.Procedure1)procedure1);
        Pair ports = this.helpers.getContractPorts(monitor, contractProtocol);
        Port regularPort = (Port)Verify.verifyNotNull((Object)((Port)IterableExtensions.head((Iterable)((Iterable)ports.getKey()))));
        Port conjugatedPort = (Port)Verify.verifyNotNull((Object)((Port)IterableExtensions.head((Iterable)((Iterable)ports.getValue()))));
        MonitorDesc monitorDesc = new MonitorDesc(contract, contractProtocol, monitor, regularPort, conjugatedPort);
        boolean bl = monitorDesc.regularPort.isConjugated();
        boolean bl2 = !bl;
        Verify.verify((boolean)bl2);
        Verify.verify((boolean)monitorDesc.conjugatedPort.isConjugated());
        this.transformStateMachine(monitorDesc);
        return monitor;
    }

    protected void transformStateMachine(@Extension MonitorDesc monitorDesc) {
        this.generateValidMessageForwarding(monitorDesc);
        ExtendedFsmGenBuilder fsmGenBuilder = this.fsmGenBuilderFactory.create();
        GraphContainer graphContainer = fsmGenBuilder.createTransformedModel((ModelComponent)monitorDesc.monitor);
        Procedures.Procedure1 procedure1 = gc -> {
            fsmGenBuilder.withCommonData(gc);
            fsmGenBuilder.withTriggersInStates(gc);
        };
        GraphContainer graphContainer2 = (GraphContainer)ObjectExtensions.operator_doubleArrow((Object)graphContainer, (Procedures.Procedure1)procedure1);
        Functions.Function1 function1 = it -> {
            StateGraphNode stateGraphNode = it.getStateGraphNode();
            return stateGraphNode instanceof State;
        };
        Procedures.Procedure1 procedure12 = node -> this.generateCatchAllTransitionToState((Node)node, monitorDesc);
        IteratorExtensions.forEach((Iterator)IteratorExtensions.filter((Iterator)FsmGenExtensions.getAllNodes((Graph)graphContainer2.getGraph()), (Functions.Function1)function1), (Procedures.Procedure1)procedure12);
    }

    protected void generateValidMessageForwarding(@Extension MonitorDesc monitorDesc) {
        Set targetPorts = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Port[]{monitorDesc.regularPort, monitorDesc.conjugatedPort}));
        List allTransitions = this.roomHelpers.getAllTransitionsRecursive(this.roomHelpers.getActualStateMachine((ModelComponent)monitorDesc.monitor));
        Functions.Function1 function1 = tr -> {
            Functions.Function1 function1 = it -> {
                Functions.Function1 function1 = it_1 -> it_1.getFrom();
                return ListExtensions.map((List)it.getMsgFromIfPairs(), (Functions.Function1)function1);
            };
            Functions.Function1 function12 = ifItem -> targetPorts.contains(ifItem);
            return IterableExtensions.forall((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)tr.getTriggers(), (Functions.Function1)function1)), (Functions.Function1)function12);
        };
        Iterable filteredTransition = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)allTransitions, TriggeredTransition.class), (Functions.Function1)function1);
        Consumer<TriggeredTransition> consumer = tr -> this.generateMessageForwarding((TriggeredTransition)tr, true, monitorDesc);
        filteredTransition.forEach(consumer);
    }

    protected Object generateMessageForwarding(TriggeredTransition transition, boolean valid, @Extension MonitorDesc monitorDesc) {
        Object object = null;
        Functions.Function1 function1 = it -> it.getMsgFromIfPairs();
        Functions.Function1 function12 = it -> this.buildMessageForwardStatement((MessageFromIf)it, monitorDesc);
        String forwards = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)transition.getTriggers(), (Functions.Function1)function1)), (Functions.Function1)function12), (CharSequence)Strings.newLine());
        Object object2 = null;
        if (valid) {
            object2 = this.addActionCodeToTriggeredTransition(transition, forwards);
        } else {
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("if(forwardInvalidMessages) {");
            stringConcatenation.newLine();
            stringConcatenation.append("\t");
            stringConcatenation.append(forwards, "\t");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("}");
            stringConcatenation.newLine();
            object2 = this.addActionCodeToTriggeredTransition(transition, stringConcatenation.toString());
        }
        object = object2;
        return object;
    }

    protected String buildMessageForwardStatement(MessageFromIf msgFromInterface, @Extension MonitorDesc monitorDesc) {
        boolean bl;
        Port port = null;
        AbstractInterfaceItem abstractInterfaceItem = msgFromInterface.getFrom();
        boolean bl2 = false;
        if (Objects.equals(abstractInterfaceItem, monitorDesc.regularPort)) {
            bl2 = true;
            port = monitorDesc.conjugatedPort;
        }
        if (!bl2 && Objects.equals(abstractInterfaceItem, monitorDesc.conjugatedPort)) {
            bl2 = true;
            port = monitorDesc.regularPort;
        }
        if (!bl2) {
            throw new IllegalArgumentException("");
        }
        Port forwardPort = port;
        EObject eObject = msgFromInterface.getMessage();
        Message originalMessage = (Message)eObject;
        String messageName = originalMessage.getName();
        String parameterName = "";
        MessageData messageData = originalMessage.getData();
        boolean bl3 = bl = messageData != null;
        if (bl) {
            parameterName = "transitionData";
        }
        String string = forwardPort.getName();
        String string2 = string + ".";
        String string3 = string2 + messageName;
        String string4 = string3 + "(";
        String string5 = string4 + parameterName;
        return string5 + ");";
    }

    protected void generateCatchAllTransitionToState(Node state, @Extension MonitorDesc monitorDesc) {
        Map<Message, List<CommonTrigger>> messageToTriggerMap = this.getOutgoingTriggersByMessage(state);
        List list = this.roomHelpers.getAllIncomingMessages(monitorDesc.contractProtocol);
        for (Message message : list) {
            this.generateCatchTransitionForMessageToState(message, monitorDesc.regularPort, state, messageToTriggerMap, monitorDesc);
        }
        List list2 = this.roomHelpers.getAllOutgoingMessages(monitorDesc.contractProtocol);
        for (Message message_1 : list2) {
            this.generateCatchTransitionForMessageToState(message_1, monitorDesc.conjugatedPort, state, messageToTriggerMap, monitorDesc);
        }
    }

    protected boolean generateCatchTransitionForMessageToState(Message message, Port port, Node state, Map<Message, List<CommonTrigger>> messageToTriggerMap, @Extension MonitorDesc monitorDesc) {
        boolean bl = false;
        List<CommonTrigger> triggers = messageToTriggerMap.getOrDefault(message, CollectionLiterals.emptyList());
        Functions.Function1 function1 = it -> {
            boolean bl = it.isHasGuard();
            return !bl;
        };
        int noOfUnguardedTriggers = IterableExtensions.size((Iterable)IterableExtensions.filter(triggers, (Functions.Function1)function1));
        boolean bl2 = false;
        if (noOfUnguardedTriggers == 0) {
            boolean bl3 = false;
            String string = port.getName();
            String inOutStr = "from_" + string;
            String string2 = state.getStateGraphNode().getName();
            String string3 = string2 + "_catch_";
            String string4 = string3 + inOutStr;
            String string5 = string4 + "_";
            String string6 = message.getName();
            String transitionName = string5 + string6;
            TriggeredTransition catchTransition = this.createTriggeredTransition(message, port, state, state, transitionName);
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("onViolation(\"");
            String string7 = this.buildProtocolErrorString(port, message, state);
            stringConcatenation.append(string7);
            stringConcatenation.append("\");");
            this.addActionCodeToTriggeredTransition(catchTransition, stringConcatenation.toString());
            this.generateMessageForwarding(catchTransition, false, monitorDesc);
            bl2 = bl3 = state.getGraph().getStateGraph().getTransitions().add((Object)catchTransition);
        }
        bl = bl2;
        return bl;
    }

    protected String buildProtocolErrorString(Port fromPort, Message message, Node fromState) {
        String protocolName = fromPort.getProtocol().getName();
        String string = message.getName();
        String string2 = "[Protocol ERROR] In protocol " + protocolName + " message " + string;
        String string3 = string2 + " from port ";
        String string4 = fromPort.getName();
        String string5 = string3 + string4;
        String string6 = string5 + " is not allowed in state ";
        String string7 = fromState.getStateGraphNode().getName();
        return string6 + string7;
    }

    protected TriggeredTransition createTriggeredTransition(Message message, Port port, Node from, Node to, String transitionName) {
        StateTerminal fromTerminal = this.fsmFactory.createStateTerminal();
        StateGraphNode stateGraphNode = from.getStateGraphNode();
        fromTerminal.setState((State)stateGraphNode);
        StateTerminal toTerminal = this.fsmFactory.createStateTerminal();
        StateGraphNode stateGraphNode2 = to.getStateGraphNode();
        toTerminal.setState((State)stateGraphNode2);
        MessageFromIf messageFromIf = this.fsmFactory.createMessageFromIf();
        messageFromIf.setFrom((AbstractInterfaceItem)port);
        messageFromIf.setMessage((EObject)message);
        Trigger trigger = this.fsmFactory.createTrigger();
        trigger.getMsgFromIfPairs().add((Object)messageFromIf);
        TriggeredTransition triggeredTransition = this.fsmFactory.createTriggeredTransition();
        triggeredTransition.getTriggers().add((Object)trigger);
        triggeredTransition.setFrom((TransitionTerminal)fromTerminal);
        triggeredTransition.setTo((TransitionTerminal)toTerminal);
        triggeredTransition.setName(transitionName);
        return triggeredTransition;
    }

    protected Object addActionCodeToTriggeredTransition(TriggeredTransition transition, String actionCode) {
        boolean bl;
        boolean bl2;
        Boolean bl3 = null;
        DetailCode detailCode = transition.getAction();
        boolean bl4 = bl2 = detailCode == null;
        if (bl2) {
            transition.setAction(this.fsmFactory.createDetailCode());
        }
        Object object = null;
        int n = transition.getAction().getLines().size();
        boolean bl5 = bl = n > 0;
        if (bl) {
            EList eList = transition.getAction().getLines();
            StringConcatenation stringConcatenation = new StringConcatenation();
            String string = (String)transition.getAction().getLines().get(0);
            stringConcatenation.append(string);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append(actionCode);
            stringConcatenation.newLineIfNotEmpty();
            object = eList.set(0, (Object)stringConcatenation.toString());
        } else {
            object = transition.getAction().getLines().add((Object)actionCode);
        }
        bl3 = object;
        return bl3;
    }

    protected Map<Message, List<CommonTrigger>> getOutgoingTriggersByMessage(Node state) {
        HashMap<Message, List<CommonTrigger>> map = new HashMap<Message, List<CommonTrigger>>();
        EList eList = state.getCaughtTriggers();
        for (CommonTrigger trigger : eList) {
            EObject eObject;
            boolean bl;
            boolean bl2 = map.containsKey(trigger.getMsg());
            boolean bl3 = bl = !bl2;
            if (bl) {
                eObject = trigger.getMsg();
                LinkedList linkedList = new LinkedList();
                map.put((Message)eObject, linkedList);
            }
            eObject = trigger.getMsg();
            map.get((Message)eObject).add(trigger);
        }
        return map;
    }

    @FinalFieldsConstructor
    protected static class MonitorDesc {
        public final ActorClass contract;
        public final ProtocolClass contractProtocol;
        public final ActorClass monitor;
        public final Port regularPort;
        public final Port conjugatedPort;

        public MonitorDesc(ActorClass contract, ProtocolClass contractProtocol, ActorClass monitor, Port regularPort, Port conjugatedPort) {
            this.contract = contract;
            this.contractProtocol = contractProtocol;
            this.monitor = monitor;
            this.regularPort = regularPort;
            this.conjugatedPort = conjugatedPort;
        }
    }
}

