/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.converter;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class LongConverter
extends AbstractValueConverter<Long> {
    public Long toValue(String string, INode node) throws ValueConverterException {
        if (Strings.isEmpty((String)string)) {
            throw new ValueConverterException("Couldn't convert empty string to integer.", node, null);
        }
        if (string.startsWith("0x") || string.startsWith("0X")) {
            try {
                long value = Long.parseLong(string.substring(2), 16);
                return value;
            }
            catch (NumberFormatException e) {
                throw new ValueConverterException("Couldn't convert '" + string + "' to hex.", node, (Exception)e);
            }
        }
        try {
            String tmp = string;
            if (string.charAt(0) == '+') {
                tmp = string.substring(1, string.length());
            }
            long value = Long.parseLong(tmp);
            return value;
        }
        catch (NumberFormatException e) {
            throw new ValueConverterException("Couldn't convert '" + string + "' to integer.", node, (Exception)e);
        }
    }

    public String toString(Long value) throws ValueConverterException {
        return value.toString();
    }
}

