/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.highlight;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.converter.BaseConverterService;
import org.eclipse.etrice.core.common.converter.CCStringConverter;
import org.eclipse.etrice.core.common.converter.CCStringIndentation;
import org.eclipse.etrice.core.common.services.BaseGrammarAccess;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.documentation.IEObjectDocumentationProviderExtension;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Pair;

public class BaseSemanticHighlighter
implements ISemanticHighlightingCalculator {
    @Inject
    BaseGrammarAccess grammar;
    @Inject
    BaseConverterService converterService;
    @Inject(optional=true)
    IEObjectDocumentationProviderExtension docuProvider;

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        if (resource == null || resource.getParseResult() == null) {
            return;
        }
        ICompositeNode root = resource.getParseResult().getRootNode();
        for (INode node : root.getAsTreeIterable()) {
            if (cancelIndicator.isCanceled()) break;
            this.provideHighlightingFor(node, resource, acceptor);
        }
    }

    protected void provideHighlightingFor(INode node, XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        EObject semanticObj;
        EObject grammarElement = node.getGrammarElement();
        if (grammarElement instanceof RuleCall) {
            AbstractRule rule = ((RuleCall)grammarElement).getRule();
            if (rule == this.grammar.getCC_STRINGRule()) {
                this.ccStringHighlight(node, acceptor, this.converterService.getCC_StringConverter());
            } else if (rule == this.grammar.getNumberLiteralRule()) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"number"});
            }
        } else if (grammarElement == this.grammar.getAnnotationAccess().getTypeAnnotationTypeCrossReference_1_0() || grammarElement == this.grammar.getAnnotationAccess().getCommercialAtKeyword_0()) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"hl_annotation"});
        } else if (this.docuProvider != null && grammarElement == this.grammar.getML_COMMENTRule() && (semanticObj = NodeModelUtils.findActualSemanticObjectFor((INode)node)) != null && this.docuProvider.getDocumentationNodes(semanticObj).contains(node)) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"documentation"});
        }
    }

    protected void ccStringHighlight(INode node, IHighlightedPositionAcceptor acceptor, CCStringConverter converter) {
        String delim = converter.getDelim();
        if (node.getText() == null || node.getText().length() < delim.length() * 2) {
            return;
        }
        acceptor.addPosition(node.getOffset(), delim.length(), new String[]{"string"});
        acceptor.addPosition(node.getEndOffset() - delim.length(), delim.length(), new String[]{"string"});
        int offset = node.getOffset() + delim.length();
        List lineStartLength = new CCStringIndentation(converter.stripDelim(node.getText())).highlight();
        for (Pair offsetLength : lineStartLength) {
            acceptor.addPosition(offset + (Integer)offsetLength.getKey(), ((Integer)offsetLength.getValue()).intValue(), new String[]{"ccstring"});
        }
    }
}

