/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ide.server;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.eclipse.etrice.core.common.ide.modelpath.ModelPathManager;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.WorkspaceFoldersChangeEvent;
import org.eclipse.xtext.ide.server.LanguageServerImpl;
import org.eclipse.xtext.util.CancelIndicator;

public class ModelLanguageServer
extends LanguageServerImpl {
    @Inject
    private ModelPathManager modelpathManager;

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        if (this.getLanguageServerAccess().getInitializeParams() == null && params.getWorkspaceFolders() != null) {
            this.getRequestManager().runWrite(() -> {
                this.modelpathManager.workspaceFoldersChanged(params.getWorkspaceFolders(), Collections.emptyList());
                return null;
            }, (a, b) -> null);
        }
        return super.initialize(params);
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        this.getRequestManager().runWrite(() -> {
            this.modelpathManager.workspaceFoldersChanged(params.getEvent().getAdded(), params.getEvent().getRemoved());
            this.getWorkspaceManager().didChangeWorkspaceFolders(params, CancelIndicator.NullImpl);
            return null;
        }, (a, b) -> null);
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        this.getRequestManager().runWrite(() -> {
            if (this.modelpathManager.filesChanged(params.getChanges())) {
                this.getWorkspaceManager().didChangeWorkspaceFolders(new DidChangeWorkspaceFoldersParams(new WorkspaceFoldersChangeEvent(Collections.emptyList(), Collections.emptyList())), CancelIndicator.NullImpl);
            }
            return this.toBuildable(params);
        }, (cancelIndicator, buildable) -> buildable.build(cancelIndicator));
    }
}

