//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2025, 2026 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.cif.datasynth.settings;

import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.datasynth.CifDataSynthesis;
import org.eclipse.escet.cif.datasynth.CifDataSynthesisResult;

/**
 * This enumeration lists certain BDD predicates that are freed by data-based synthesis once they are no longer needed,
 * for which there are specific cases where it may be needed or convenient to keep them a bit longer. Each enumeration
 * constant indicates a particular BDD or set of BDDs that is normally freed in specific places, and for which it is
 * possible to forego freeing it/them.
 *
 * <p>
 * Freeing the BDDs once they are no longer needed can help to reduce memory usage of the BDDs, while keeping them alive
 * allows them to still be used afterwards.
 * </p>
 */
public enum CifDataSynthesisFree {
    /** Free {@link CifBddEdge#origGuard} in {@link CifDataSynthesis#determineGuards}. */
    EDGE_ORIG_GUARD,

    /** Free {@link CifBddEdge#guard} in {@link CifDataSynthesis#determineGuards}. */
    EDGE_GUARD,

    /**
     * Free {@link CifBddSpec#initialPlantInv} and set it to {@code null} in
     * {@link CifDataSynthesis#determineCtrlSysInit}.
     */
    SPEC_INITIAL_PLANT_INV,

    /** Free {@link CifBddSpec#marked} and set it to {@code null} in {@link CifDataSynthesis#synthesize}. */
    SPEC_MARKED,

    /**
     * Free {@link CifDataSynthesisResult#initialCtrl} and set it to {@code null} in
     * {@link CifDataSynthesis#determineOutputInitial}.
     */
    RESULT_INITIAL_CTRL,

    /**
     * Free {@link CifDataSynthesisResult#ctrlBeh} and set it to {@code null} in
     * {@link CifDataSynthesis#determineOutputGuards}.
     */
    RESULT_CTRL_BEH,
}
