//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2010, 2025 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.cif.bdd.conversion.bitvectors;

import com.github.javabdd.BDD;

/** An {@link UnsignedBddBitVector} and a carry {@link BDD}. */
public class UnsignedBddBitVectorAndCarry
        extends BddBitVectorAndCarry<UnsignedBddBitVector, UnsignedBddBitVectorAndCarry>
{
    /**
     * Constructor for the {@link UnsignedBddBitVectorAndCarry} class.
     *
     * @param vector The BDD bit vector.
     * @param carry The carry bit as BDD.
     */
    public UnsignedBddBitVectorAndCarry(UnsignedBddBitVector vector, BDD carry) {
        super(vector, carry);
    }
}
