/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.escet.common.java.Lists;

public class MultiClassLoader
extends ClassLoader {
    private final List<ClassLoader> loaders;

    public MultiClassLoader(List<ClassLoader> loaders) {
        this.loaders = loaders;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (ClassLoader loader : this.loaders) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException();
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader loader : this.loaders) {
            URL resource = loader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        List urls = Lists.list();
        for (ClassLoader loader : this.loaders) {
            Enumeration<URL> loaderUrls = loader.getResources(name);
            urls.addAll(Collections.list(loaderUrls));
        }
        return Collections.enumeration(urls);
    }
}

