/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.Splitter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.ui.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryEntry;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryNode;
import org.eclipse.ltk.ui.refactoring.history.IRefactoringHistoryControl;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryContentProvider;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryLabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;

public class RefactoringHistoryControl
extends Composite
implements IRefactoringHistoryControl {
    private final Set<RefactoringDescriptorProxy> fCheckedDescriptors = new HashSet<RefactoringDescriptorProxy>();
    protected final RefactoringHistoryControlConfiguration fControlConfiguration;
    private Text fDetailField = null;
    private Label fDetailLabel = null;
    protected CompareViewerPane fHistoryPane = null;
    protected TreeViewer fHistoryViewer = null;
    private final Set<RefactoringDescriptorProxy> fSelectedDescriptors = new HashSet<RefactoringDescriptorProxy>();
    private Label fSelectionLabel = null;
    private Splitter fSplitterControl = null;

    public RefactoringHistoryControl(Composite parent, RefactoringHistoryControlConfiguration configuration) {
        super(parent, 0);
        Assert.isNotNull((Object)configuration);
        this.fControlConfiguration = configuration;
    }

    @Override
    public final void addCheckStateListener(ICheckStateListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fHistoryViewer instanceof RefactoringHistoryTreeViewer) {
            RefactoringHistoryTreeViewer viewer = (RefactoringHistoryTreeViewer)this.fHistoryViewer;
            viewer.addCheckStateListener(listener);
        }
    }

    @Override
    public final void addSelectionChangedListener(ISelectionChangedListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fHistoryViewer != null) {
            this.fHistoryViewer.addSelectionChangedListener(listener);
        }
    }

    protected void createBottomButtonBar(Composite parent) {
    }

    @Override
    public void createControl() {
        RefactoringCore.getHistoryService().connect();
        GridLayout layout = new GridLayout(this.getContainerColumns(), false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        this.fSplitterControl = new Splitter((Composite)this, 512);
        this.fSplitterControl.setLayoutData((Object)new GridData(1808));
        this.createRightButtonBar(this);
        Composite leftPane = new Composite((Composite)this.fSplitterControl, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        layout.verticalSpacing = 2;
        leftPane.setLayout((Layout)layout);
        this.fHistoryPane = new CompareViewerPane(leftPane, 0x800800);
        this.fHistoryPane.setText(this.getHistoryPaneText());
        this.fHistoryPane.setLayoutData((Object)new GridData(1808));
        this.fHistoryViewer = this.createHistoryViewer((Composite)this.fHistoryPane);
        if (!this.fControlConfiguration.isTimeDisplayed()) {
            this.fHistoryViewer.setAutoExpandLevel(-1);
        }
        this.fHistoryViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fHistoryViewer.setUseHashlookup(true);
        this.fHistoryViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.fHistoryViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fHistoryViewer.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.handleSelectionChanged((IStructuredSelection)selection);
            }
        });
        this.fHistoryPane.setContent(this.fHistoryViewer.getControl());
        this.createToolBar((ViewForm)this.fHistoryPane);
        this.createDetailPane((Composite)this.fSplitterControl);
        MouseAdapter listener = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                Control content = RefactoringHistoryControl.this.fHistoryPane.getContent();
                if (content != null && content.getBounds().contains(event.x, event.y)) {
                    return;
                }
                Composite control = RefactoringHistoryControl.this.fHistoryPane.getParent().getParent();
                if (control instanceof Splitter) {
                    ((Splitter)control).setMaximizedControl((Control)RefactoringHistoryControl.this.fHistoryPane.getParent());
                }
            }
        };
        this.addMouseListener((MouseListener)listener);
        this.fHistoryPane.getTopLeft().addMouseListener((MouseListener)listener);
        this.fSplitterControl.setWeights(new int[]{65, 35});
        this.createBottomButtonBar(this);
        Dialog.applyDialogFont((Control)this);
    }

    protected void createDetailLabel(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.fDetailLabel = new Label(parent, 16704);
        this.fDetailLabel.setText(RefactoringUIMessages.RefactoringHistoryControl_comment_viewer_label);
        GridData data = new GridData(32);
        data.horizontalSpan = 1;
        this.fDetailLabel.setLayoutData((Object)data);
    }

    protected Composite createDetailPane(Composite parent) {
        Assert.isNotNull((Object)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(this.getDetailColumns(), true);
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.createDetailLabel(composite);
        this.createSelectionLabel(composite);
        this.fDetailField = new Text(composite, 8391434);
        this.fDetailField.setBackground(this.getDisplay().getSystemColor(22));
        this.fDetailField.setText(this.fControlConfiguration.getCommentCaption());
        GridData data = new GridData(1808);
        data.horizontalSpan = this.getDetailColumns();
        this.fDetailField.setLayoutData((Object)data);
        return composite;
    }

    protected TreeViewer createHistoryViewer(Composite parent) {
        Assert.isNotNull((Object)parent);
        if (this.fControlConfiguration.isCheckableViewer()) {
            return new RefactoringHistoryTreeViewer(parent, 768);
        }
        return new TreeViewer(parent, 768);
    }

    protected void createRightButtonBar(Composite parent) {
    }

    protected void createSelectionLabel(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.fSelectionLabel = new Label(parent, 131392);
        GridData data = new GridData(128);
        data.horizontalSpan = 1;
        this.fSelectionLabel.setLayoutData((Object)data);
    }

    protected void createToolBar(ViewForm parent) {
    }

    public final void dispose() {
        RefactoringCore.getHistoryService().disconnect();
        super.dispose();
    }

    @Override
    public final RefactoringDescriptorProxy[] getCheckedDescriptors() {
        if (this.fHistoryViewer instanceof RefactoringHistoryTreeViewer) {
            return this.fCheckedDescriptors.toArray(new RefactoringDescriptorProxy[this.fCheckedDescriptors.size()]);
        }
        return this.getSelectedDescriptors();
    }

    protected int getContainerColumns() {
        return 2;
    }

    protected RefactoringHistoryContentProvider getContentProvider() {
        return this.fControlConfiguration.getContentProvider();
    }

    @Override
    public final Control getControl() {
        return this;
    }

    private Collection<RefactoringDescriptorProxy> getCoveredDescriptors(Object element) {
        Assert.isNotNull((Object)element);
        HashSet<RefactoringDescriptorProxy> set = new HashSet<RefactoringDescriptorProxy>();
        this.getCoveredDescriptors(element, set);
        return set;
    }

    private void getCoveredDescriptors(Object element, Set<RefactoringDescriptorProxy> set) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull(set);
        RefactoringHistoryContentProvider provider = (RefactoringHistoryContentProvider)this.fHistoryViewer.getContentProvider();
        if (provider != null) {
            if (element instanceof RefactoringHistoryEntry) {
                RefactoringHistoryEntry entry = (RefactoringHistoryEntry)element;
                RefactoringDescriptorProxy proxy = entry.getDescriptor();
                set.add(proxy);
            } else {
                Object[] objectArray = provider.getChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (child instanceof RefactoringHistoryNode) {
                        this.getCoveredDescriptors(child, set);
                    }
                    ++n2;
                }
            }
        }
    }

    protected int getDetailColumns() {
        return 2;
    }

    private String getHistoryPaneText() {
        String text = null;
        IProject project = this.fControlConfiguration.getProject();
        text = project != null ? Messages.format(this.fControlConfiguration.getProjectPattern(), BasicElementLabels.getResourceName((IResource)project)) : this.fControlConfiguration.getWorkspaceCaption();
        return text;
    }

    public final RefactoringHistory getInput() {
        return (RefactoringHistory)this.fHistoryViewer.getInput();
    }

    protected RefactoringHistoryLabelProvider getLabelProvider() {
        return this.fControlConfiguration.getLabelProvider();
    }

    @Override
    public final RefactoringDescriptorProxy[] getSelectedDescriptors() {
        return this.fSelectedDescriptors.toArray(new RefactoringDescriptorProxy[this.fSelectedDescriptors.size()]);
    }

    protected void handleCheckStateChanged() {
        RefactoringHistory history;
        if (this.fSelectionLabel != null && (history = this.getInput()) != null) {
            int total = history.getDescriptors().length;
            int checked = this.fCheckedDescriptors.size();
            if (this.fSelectionLabel.isEnabled()) {
                if (total > 0 && this.fControlConfiguration.isCheckableViewer()) {
                    this.fSelectionLabel.setText(Messages.format(RefactoringUIMessages.RefactoringHistoryControl_selection_pattern, new String[]{String.valueOf(checked), String.valueOf(total)}));
                } else {
                    this.fSelectionLabel.setText(RefactoringUIMessages.RefactoringHistoryControl_no_selection);
                }
            } else {
                this.fSelectionLabel.setText("");
            }
        }
    }

    protected void handleSelectionChanged(IStructuredSelection selection) {
        Object[] elements;
        Assert.isNotNull((Object)selection);
        this.fSelectedDescriptors.clear();
        Object[] objectArray = elements = selection.toArray();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof RefactoringHistoryEntry) {
                RefactoringHistoryEntry entry = (RefactoringHistoryEntry)element;
                RefactoringDescriptorProxy proxy = entry.getDescriptor();
                this.fSelectedDescriptors.add(proxy);
            } else if (element instanceof RefactoringHistoryNode) {
                RefactoringHistoryNode node = (RefactoringHistoryNode)element;
                this.fSelectedDescriptors.addAll(this.getCoveredDescriptors(node));
            }
            ++n2;
        }
        if (elements.length == 1 && elements[0] instanceof RefactoringHistoryEntry) {
            RefactoringHistoryEntry entry = (RefactoringHistoryEntry)elements[0];
            final RefactoringDescriptorProxy proxy = entry.getDescriptor();
            UIJob job = new UIJob(RefactoringUIMessages.RefactoringHistoryControl_resolving_information){

                public final IStatus runInUIThread(IProgressMonitor monitor) {
                    RefactoringDescriptor descriptor = proxy.requestDescriptor(monitor);
                    if (descriptor != null) {
                        String comment = descriptor.getComment();
                        if ("".equals(comment)) {
                            comment = RefactoringUIMessages.RefactoringHistoryControl_no_comment;
                        }
                        RefactoringHistoryControl.this.fDetailField.setText(comment);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        } else {
            this.fDetailField.setText(this.fControlConfiguration.getCommentCaption());
        }
    }

    public void reconcileCheckState() {
        RefactoringHistory history = this.getInput();
        if (history != null && this.fHistoryViewer instanceof RefactoringHistoryTreeViewer) {
            ((RefactoringHistoryTreeViewer)this.fHistoryViewer).reconcileCheckState(history);
        }
    }

    public void reconcileSelectionState() {
        Object[] nodes = new RefactoringHistoryNode[this.fSelectedDescriptors.size()];
        int index = 0;
        for (RefactoringDescriptorProxy descriptor : this.fSelectedDescriptors) {
            nodes[index] = new RefactoringHistoryEntry(null, descriptor);
            this.fHistoryViewer.expandToLevel(nodes[index], -1);
            ++index;
        }
        this.fHistoryViewer.setSelection((ISelection)new StructuredSelection(nodes), true);
    }

    @Override
    public final void removeCheckStateListener(ICheckStateListener listener) {
        Assert.isNotNull((Object)listener);
        Assert.isNotNull((Object)listener);
        if (this.fHistoryViewer instanceof RefactoringHistoryTreeViewer) {
            RefactoringHistoryTreeViewer viewer = (RefactoringHistoryTreeViewer)this.fHistoryViewer;
            viewer.removeCheckStateListener(listener);
        }
    }

    @Override
    public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fHistoryViewer != null) {
            this.fHistoryViewer.removeSelectionChangedListener(listener);
        }
    }

    @Override
    public final void setCheckedDescriptors(RefactoringDescriptorProxy[] descriptors) {
        Assert.isNotNull((Object)descriptors);
        if (this.fHistoryViewer instanceof RefactoringHistoryTreeViewer) {
            this.fCheckedDescriptors.clear();
            this.fCheckedDescriptors.addAll(Arrays.asList(descriptors));
            RefactoringHistoryTreeViewer viewer = (RefactoringHistoryTreeViewer)this.fHistoryViewer;
            RefactoringHistory history = this.getInput();
            if (history != null) {
                viewer.reconcileCheckState(history);
            }
            this.handleCheckStateChanged();
        } else {
            this.setSelectedDescriptors(descriptors);
        }
    }

    protected void setExpandedState() {
        RefactoringHistoryContentProvider provider = (RefactoringHistoryContentProvider)this.fHistoryViewer.getContentProvider();
        if (provider != null) {
            this.handleCheckStateChanged();
            Object[] roots = provider.getRootElements();
            if (roots != null) {
                Object[] objectArray = roots;
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    Object root = objectArray[n2];
                    if (!(root instanceof RefactoringHistoryEntry)) {
                        this.fHistoryViewer.setExpandedState(root, true);
                        return;
                    }
                    ++n2;
                }
            }
        }
    }

    protected void setHistoryControlEnablement() {
        RefactoringDescriptorProxy[] proxies;
        boolean enable = false;
        RefactoringHistory history = (RefactoringHistory)this.fHistoryViewer.getInput();
        if (history != null && (proxies = history.getDescriptors()).length > 0) {
            enable = true;
        }
        if (this.fDetailField != null) {
            this.fDetailField.setEnabled(enable);
            this.fDetailField.setText(enable ? this.fControlConfiguration.getCommentCaption() : "");
        }
        if (this.fDetailLabel != null) {
            this.fDetailLabel.setEnabled(enable);
        }
        if (this.fHistoryPane != null) {
            this.fHistoryPane.setEnabled(enable);
        }
        if (this.fSelectionLabel != null) {
            this.fSelectionLabel.setEnabled(enable);
            this.fSelectionLabel.setText(enable ? RefactoringUIMessages.RefactoringHistoryControl_no_selection : "");
        }
    }

    @Override
    public void setInput(RefactoringHistory history) {
        RefactoringHistoryContentProvider provider;
        this.fHistoryViewer.setInput((Object)history);
        this.fSelectedDescriptors.clear();
        this.fCheckedDescriptors.clear();
        if (history != null && (provider = (RefactoringHistoryContentProvider)this.fHistoryViewer.getContentProvider()) != null) {
            provider.inputChanged((Viewer)this.fHistoryViewer, null, history);
            this.setHistoryControlEnablement();
        }
    }

    @Override
    public final void setSelectedDescriptors(RefactoringDescriptorProxy[] descriptors) {
        Assert.isNotNull((Object)descriptors);
        if (this.fHistoryViewer != null) {
            this.fSelectedDescriptors.clear();
            this.fSelectedDescriptors.addAll(Arrays.asList(descriptors));
            Object[] nodes = new RefactoringHistoryNode[descriptors.length];
            int index = 0;
            while (index < descriptors.length) {
                nodes[index] = new RefactoringHistoryEntry(null, descriptors[index]);
                ++index;
            }
            this.fHistoryViewer.setSelection((ISelection)new StructuredSelection(nodes));
        }
    }

    protected final class RefactoringHistoryTreeViewer
    extends CheckboxTreeViewer {
        public RefactoringHistoryTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.addCheckStateListener(event -> {
                this.reconcileCheckState(event.getElement(), event.getChecked());
                RefactoringHistoryControl.this.handleCheckStateChanged();
            });
            this.addTreeListener(new ITreeViewerListener(){

                public final void treeCollapsed(TreeExpansionEvent event) {
                }

                public final void treeExpanded(TreeExpansionEvent event) {
                    BusyIndicator.showWhile((Display)RefactoringHistoryControl.this.getDisplay(), () -> {
                        Object element = event.getElement();
                        if (RefactoringHistoryTreeViewer.this.getGrayed(element)) {
                            RefactoringHistory history = RefactoringHistoryControl.this.getInput();
                            if (history != null) {
                                RefactoringHistoryTreeViewer.this.reconcileCheckState(history);
                            }
                        } else if (RefactoringHistoryTreeViewer.this.getChecked(element)) {
                            RefactoringHistoryTreeViewer.this.setSubTreeGrayed(element, false);
                            RefactoringHistoryTreeViewer.this.setSubtreeChecked(element, true);
                        }
                    });
                }
            });
        }

        private Object[] getChildren(Object element) {
            return ((RefactoringHistoryContentProvider)this.getContentProvider()).getChildren(element);
        }

        private void reconcileCheckState(Object element) {
            Object[] objectArray = this.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.reconcileCheckState(child);
                ++n2;
            }
            int checkCount = 0;
            Collection<RefactoringDescriptorProxy> collection = RefactoringHistoryControl.this.getCoveredDescriptors(element);
            for (RefactoringDescriptorProxy proxy : collection) {
                if (!RefactoringHistoryControl.this.fCheckedDescriptors.contains(proxy)) continue;
                ++checkCount;
            }
            this.setElementChecked(element, checkCount > 0);
            this.setElementGrayed(element, checkCount != 0 && checkCount != collection.size());
        }

        private void reconcileCheckState(Object element, boolean checked) {
            if (element instanceof RefactoringHistoryEntry) {
                RefactoringHistoryEntry entry = (RefactoringHistoryEntry)element;
                RefactoringDescriptorProxy proxy = entry.getDescriptor();
                if (checked) {
                    RefactoringHistoryControl.this.fCheckedDescriptors.add(proxy);
                } else {
                    RefactoringHistoryControl.this.fCheckedDescriptors.remove(proxy);
                }
            } else if (element instanceof RefactoringHistoryNode) {
                Collection<RefactoringDescriptorProxy> collection = RefactoringHistoryControl.this.getCoveredDescriptors(element);
                if (checked) {
                    RefactoringHistoryControl.this.fCheckedDescriptors.addAll(collection);
                } else {
                    RefactoringHistoryControl.this.fCheckedDescriptors.removeAll(collection);
                }
            }
            RefactoringHistoryControl.this.reconcileCheckState();
        }

        private void setElementChecked(Object element, boolean checked) {
            Widget widget = this.findItem(element);
            if (widget instanceof TreeItem) {
                TreeItem item = (TreeItem)widget;
                item.setChecked(checked);
            }
        }

        private void setElementGrayed(Object element, boolean grayed) {
            Widget widget = this.findItem(element);
            if (widget instanceof TreeItem) {
                TreeItem item = (TreeItem)widget;
                item.setGrayed(grayed);
            }
        }

        private void setSubTreeGrayed(Object element, boolean grayed) {
            this.setElementGrayed(element, grayed);
            Object[] objectArray = this.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.setSubTreeGrayed(child, grayed);
                ++n2;
            }
        }
    }
}

