/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.cif2cif.ElimAutCasts;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimEquations;
import org.eclipse.escet.cif.cif2cif.ElimLocRefExprs;
import org.eclipse.escet.cif.cif2cif.ElimSelf;
import org.eclipse.escet.cif.cif2cif.ElimTupleFieldProjs;
import org.eclipse.escet.cif.cif2cif.RemovePositionInfo;
import org.eclipse.escet.cif.cif2cif.SwitchesToIfs;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifExecSchemeUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Alphabet;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class LinearizeBase
extends CifWalker
implements CifToCifTransformation {
    private final Map<DiscVariable, String> lpVarToAbsAutNameMap = Maps.map();
    private final boolean optInits;
    protected final WarnOutput warnOutput;
    protected ElimLocRefExprs lpIntroducer;
    protected List<CifEventUtils.Alphabets> alphabets;

    public LinearizeBase(boolean optInits, WarnOutput warnOutput) {
        this.optInits = optInits;
        this.warnOutput = warnOutput;
    }

    @Override
    public void transform(Specification spec) {
        new RemovePositionInfo().transform(spec);
        new ElimComponentDefInst().transform(spec);
        List orderedEvents = Lists.list();
        CifCollectUtils.collectEvents((ComplexComponent)spec, (Collection)orderedEvents);
        CifExecSchemeUtils.orderEvents((List)orderedEvents);
        List auts = Lists.list();
        CifCollectUtils.collectAutomata((ComplexComponent)spec, (Collection)auts);
        CifExecSchemeUtils.orderAutomata((List)auts);
        new ElimSelf().transform(spec);
        new SwitchesToIfs().transform(spec);
        new ElimEquations().transform(spec);
        new ElimAutCasts().transform(spec);
        this.lpIntroducer = new ElimLocRefExprs(a -> "__Dummy_LP_Name_Very_Unlikely_To_Exist__", a -> "LPE", l -> l.getName(), false, false, false, this.lpVarToAbsAutNameMap, this.optInits, false, true, true, this.warnOutput);
        this.lpIntroducer.transform(spec);
        if (auts.isEmpty()) {
            String msg = "Linearization of CIF specifications without automata is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        Set specNames = CifScopeUtils.getSymbolNamesForScope((PositionObject)spec, null);
        Automaton aut = this.createAutomaton(spec, specNames);
        Set autNames = Sets.set();
        aut.setKind(this.mergeAutKinds(auts));
        this.alphabets = CifEventUtils.getAllAlphabets((List)auts, null);
        aut.setAlphabet(this.mergeAlphabets(orderedEvents));
        this.moveDiscAndContVars(aut, auts, autNames);
        this.mergeLocInvInitMarked(auts);
        Location loc = this.createLocation(aut, autNames);
        this.createEdges(auts, aut, loc);
        this.mergeTauEdges(auts, aut, loc);
        List edges = Lists.copy((List)loc.getEdges());
        Collections.sort(edges, new EdgeSorter(orderedEvents));
        loc.getEdges().clear();
        loc.getEdges().addAll((Collection)edges);
        this.removeChannelDataTypes(orderedEvents);
        this.handleUrgency(auts, aut, autNames);
        this.convertAutomataToGroups(auts);
        this.postprocess(spec);
    }

    private Automaton createAutomaton(Specification spec, Set<String> specNames) {
        Automaton aut = CifConstructors.newAutomaton();
        spec.getComponents().add((Object)aut);
        String name = "M";
        if (specNames.contains(name)) {
            String oldName = name;
            name = CifScopeUtils.getUniqueName((String)name, specNames, Collections.emptySet());
            this.warnOutput.line("Merged automaton \"%s\" is renamed to \"%s\".", new Object[]{oldName, name});
        }
        specNames.add(name);
        aut.setName(name);
        return aut;
    }

    private SupKind mergeAutKinds(List<Automaton> auts) {
        SupKind mergedKind = null;
        boolean first = true;
        for (Automaton aut : auts) {
            if (first) {
                mergedKind = aut.getKind();
                first = false;
                continue;
            }
            if (mergedKind == aut.getKind()) continue;
            mergedKind = SupKind.NONE;
        }
        Assert.notNull(mergedKind);
        return mergedKind;
    }

    private Alphabet mergeAlphabets(List<Event> orderedEventDecls) {
        Set alphabetEvents = Sets.set();
        for (CifEventUtils.Alphabets autAlphabets : this.alphabets) {
            alphabetEvents.addAll(autAlphabets.syncAlphabet);
            alphabetEvents.addAll(autAlphabets.sendAlphabet);
            alphabetEvents.addAll(autAlphabets.recvAlphabet);
        }
        List events = Lists.copy(orderedEventDecls);
        events.retainAll(alphabetEvents);
        Alphabet alphabet = CifConstructors.newAlphabet();
        EList eventRefs = alphabet.getEvents();
        for (Event event : events) {
            EventExpression eventRef = CifConstructors.newEventExpression();
            eventRef.setEvent(event);
            eventRef.setType((CifType)CifConstructors.newBoolType());
            eventRefs.add(eventRef);
        }
        return alphabet;
    }

    private Location createLocation(Automaton aut, Set<String> autNames) {
        Location loc = CifConstructors.newLocation();
        aut.getLocations().add((Object)loc);
        String name = "L";
        if (autNames.contains(name)) {
            String oldName = name;
            name = CifScopeUtils.getUniqueName((String)name, autNames, Collections.emptySet());
            this.warnOutput.line("Merged location \"%s\" is renamed to \"%s\".", new Object[]{oldName, name});
        }
        autNames.add(name);
        loc.setName(name);
        loc.getInitials().add((Object)CifValueUtils.makeTrue());
        loc.getMarkeds().add((Object)CifValueUtils.makeTrue());
        return loc;
    }

    private void moveDiscAndContVars(Automaton mergedAut, List<Automaton> auts, Set<String> autNames) {
        List decls = Lists.list();
        Set declNames = Sets.set();
        for (Automaton aut : auts) {
            for (Declaration decl : aut.getDeclarations()) {
                if (!(decl instanceof DiscVariable) && !(decl instanceof ContVariable)) continue;
                decls.add(decl);
                String name = this.lpVarToAbsAutNameMap.get(decl);
                if (name == null) {
                    name = CifTextUtils.getAbsName((PositionObject)decl, (boolean)false);
                }
                name = name.replace(".", "_");
                decl.setName(name);
                declNames.add(name);
            }
        }
        EList newDecls = mergedAut.getDeclarations();
        for (Declaration decl : decls) {
            newDecls.add(decl);
            String name = decl.getName();
            if (autNames.contains(name)) {
                String oldName = name;
                name = CifScopeUtils.getUniqueName((String)name, autNames, (Set)declNames);
                decl.setName(name);
                this.warnOutput.line("Declaration \"%s\" is renamed to \"%s\".", new Object[]{oldName, name});
            }
            autNames.add(name);
        }
    }

    private void mergeLocInvInitMarked(List<Automaton> auts) {
        Expression lexpr;
        for (Automaton aut : auts) {
            for (Location loc : aut.getLocations()) {
                for (Invariant inv : Lists.copy((List)loc.getInvariants())) {
                    lexpr = this.lpIntroducer.createLocRef(loc);
                    BinaryExpression bexpr = CifConstructors.newBinaryExpression();
                    bexpr.setOperator(BinaryOperator.IMPLICATION);
                    bexpr.setLeft(lexpr);
                    bexpr.setRight(inv.getPredicate());
                    bexpr.setType((CifType)CifConstructors.newBoolType());
                    inv.setPredicate((Expression)bexpr);
                    aut.getInvariants().add((Object)inv);
                }
            }
        }
        for (Automaton aut : auts) {
            List inits = Lists.list();
            for (Location loc : aut.getLocations()) {
                BoolExpression init = loc.getInitials().isEmpty() ? CifValueUtils.makeFalse() : CifValueUtils.createConjunction((List)loc.getInitials());
                lexpr = this.lpIntroducer.createLocRef(loc);
                inits.add(CifValueUtils.createConjunction((List)Lists.list((Object[])new Expression[]{lexpr, init})));
            }
            aut.getInitials().add((Object)CifValueUtils.createDisjunction((List)inits));
        }
        for (Automaton aut : auts) {
            List markers = Lists.list();
            for (Location loc : aut.getLocations()) {
                BoolExpression marker = loc.getMarkeds().isEmpty() ? CifValueUtils.makeFalse() : CifValueUtils.createConjunction((List)loc.getMarkeds());
                lexpr = this.lpIntroducer.createLocRef(loc);
                markers.add(CifValueUtils.createConjunction((List)Lists.list((Object[])new Expression[]{lexpr, marker})));
            }
            aut.getMarkeds().add((Object)CifValueUtils.createDisjunction((List)markers));
        }
    }

    private void mergeTauEdges(List<Automaton> auts, Automaton mergedAut, Location mergedLoc) {
        for (Automaton aut : auts) {
            for (Location loc : aut.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    boolean isTauEdge = false;
                    if (edge.getEvents().isEmpty()) {
                        isTauEdge = true;
                    }
                    for (EdgeEvent edgeEvent : edge.getEvents()) {
                        if (!(edgeEvent.getEvent() instanceof TauExpression)) continue;
                        isTauEdge = true;
                        break;
                    }
                    if (!isTauEdge) continue;
                    Expression newGuard = CifValueUtils.createConjunction((List)Lists.concat((Object)this.lpIntroducer.createLocRef(loc), (List)EMFHelper.deepclone((List)edge.getGuards())));
                    List newUpdates = EMFHelper.deepclone((List)edge.getUpdates());
                    Edge newEdge = CifConstructors.newEdge();
                    newEdge.getGuards().add((Object)newGuard);
                    newEdge.getUpdates().addAll((Collection)newUpdates);
                    TauExpression tauRef = CifConstructors.newTauExpression();
                    tauRef.setType((CifType)CifConstructors.newBoolType());
                    EdgeEvent edgeEvent = CifConstructors.newEdgeEvent();
                    edgeEvent.setEvent((Expression)tauRef);
                    newEdge.getEvents().add((Object)edgeEvent);
                    mergedLoc.getEdges().add((Object)newEdge);
                }
            }
        }
    }

    protected abstract void createEdges(List<Automaton> var1, Automaton var2, Location var3);

    protected static List<Update> replaceUpdates(List<Update> updates, Expression sendValue) {
        List rslt = EMFHelper.deepclone(updates);
        if (sendValue == null) {
            return rslt;
        }
        UpdateExprReplacer replacer = new UpdateExprReplacer(sendValue);
        for (Update update : rslt) {
            LinearizeBase.replaceUpdate(update, replacer);
        }
        return rslt;
    }

    private static void replaceUpdate(Update update, UpdateExprReplacer replacer) {
        if (update instanceof IfUpdate) {
            IfUpdate iupdate = (IfUpdate)update;
            for (Expression guard : iupdate.getGuards()) {
                LinearizeBase.replaceUpdateExpr(guard, replacer);
            }
            for (Update child : iupdate.getThens()) {
                LinearizeBase.replaceUpdate(child, replacer);
            }
            for (ElifUpdate elif : iupdate.getElifs()) {
                for (Expression guard : elif.getGuards()) {
                    LinearizeBase.replaceUpdateExpr(guard, replacer);
                }
                for (Update child : elif.getThens()) {
                    LinearizeBase.replaceUpdate(child, replacer);
                }
            }
            for (Update child : iupdate.getElses()) {
                LinearizeBase.replaceUpdate(child, replacer);
            }
            return;
        }
        Assignment asgn = (Assignment)update;
        LinearizeBase.replaceUpdateExpr(asgn.getAddressable(), replacer);
        LinearizeBase.replaceUpdateExpr(asgn.getValue(), replacer);
    }

    private static void replaceUpdateExpr(Expression expr, UpdateExprReplacer replacer) {
        replacer.replaced = false;
        replacer.replace(expr);
        if (replacer.replaced) {
            new ElimTupleFieldProjs().transform(expr);
        }
    }

    public List<DiscVariable> getLPVariables() {
        List lpVariables = Lists.listc((int)this.lpVarToAbsAutNameMap.size());
        lpVariables.addAll(this.lpVarToAbsAutNameMap.keySet());
        return lpVariables;
    }

    public Map<DiscVariable, String> getLpVarToAbsAutNameMap() {
        return Collections.unmodifiableMap(this.lpVarToAbsAutNameMap);
    }

    private void removeChannelDataTypes(List<Event> events) {
        for (Event event : events) {
            event.setType(null);
        }
    }

    private void handleUrgency(List<Automaton> auts, Automaton mergedAut, Set<String> autNames) {
        List guards = Lists.list();
        for (Automaton aut : auts) {
            for (Location loc : aut.getLocations()) {
                if (loc.isUrgent()) {
                    guards.add(this.lpIntroducer.createLocRef(loc));
                }
                for (Edge edge : loc.getEdges()) {
                    if (!edge.isUrgent()) continue;
                    Expression lexpr = this.lpIntroducer.createLocRef(loc);
                    List eguards = EMFHelper.deepclone((List)edge.getGuards());
                    guards.add(CifValueUtils.createConjunction((List)Lists.concat((Object)lexpr, (List)eguards)));
                }
            }
        }
        if (guards.isEmpty()) {
            return;
        }
        VariableValue uvalue = CifConstructors.newVariableValue();
        uvalue.getValues().add((Object)CifValueUtils.makeTrue());
        DiscVariable u = CifConstructors.newDiscVariable();
        u.setType((CifType)CifConstructors.newBoolType());
        u.setValue(uvalue);
        String name = "u";
        if (autNames.contains(name)) {
            String oldName = name;
            name = CifScopeUtils.getUniqueName((String)name, autNames, Collections.emptySet());
            this.warnOutput.line("Variable \"%s\", introduced during linearization to enforce urgency, is renamed to \"%s\".", new Object[]{oldName, name});
        }
        u.setName(name);
        autNames.add(name);
        mergedAut.getDeclarations().add((Object)u);
        DiscVariableExpression uref = CifConstructors.newDiscVariableExpression();
        uref.setType((CifType)CifConstructors.newBoolType());
        uref.setVariable(u);
        Invariant inv = CifConstructors.newInvariant();
        inv.setPredicate((Expression)uref);
        inv.setSupKind(SupKind.PLANT);
        inv.setInvKind(InvKind.STATE);
        mergedAut.getInvariants().add((Object)inv);
        Assignment uasgn = CifConstructors.newAssignment();
        uasgn.setAddressable((Expression)EMFHelper.deepclone((EObject)uref));
        uasgn.setValue((Expression)CifValueUtils.makeFalse());
        Edge edge = CifConstructors.newEdge();
        edge.getGuards().add((Object)CifValueUtils.createDisjunction((List)guards));
        edge.setUrgent(true);
        edge.getUpdates().add((Object)uasgn);
        ((Location)mergedAut.getLocations().get(0)).getEdges().add((Object)edge);
    }

    private void convertAutomataToGroups(List<Automaton> auts) {
        for (Automaton aut : auts) {
            Group group = CifConstructors.newGroup();
            EMFHelper.updateParentContainment((EObject)aut, (EObject)group);
            group.setName(aut.getName());
            group.getDeclarations().addAll((Collection)aut.getDeclarations());
            group.getInitials().addAll((Collection)aut.getInitials());
            group.getInvariants().addAll((Collection)aut.getInvariants());
            group.getIoDecls().addAll((Collection)aut.getIoDecls());
            group.getMarkeds().addAll((Collection)aut.getMarkeds());
            Assert.check((boolean)aut.getEquations().isEmpty());
        }
    }

    protected void postprocess(Specification spec) {
    }

    private static class EdgeSorter
    implements Comparator<Edge> {
        private final Map<Event, Integer> order;

        public EdgeSorter(List<Event> events) {
            Assert.check((events.size() < Integer.MAX_VALUE ? 1 : 0) != 0);
            this.order = Maps.mapc((int)events.size());
            int i = 0;
            while (i < events.size()) {
                this.order.put(events.get(i), i);
                ++i;
            }
        }

        @Override
        public int compare(Edge edge1, Edge edge2) {
            int order2;
            int order1;
            Assert.check((edge1.getEvents().size() == 1 ? 1 : 0) != 0);
            Assert.check((edge2.getEvents().size() == 1 ? 1 : 0) != 0);
            Expression eventRef1 = ((EdgeEvent)Lists.first((List)edge1.getEvents())).getEvent();
            Expression eventRef2 = ((EdgeEvent)Lists.first((List)edge2.getEvents())).getEvent();
            if (eventRef1 instanceof TauExpression) {
                order1 = Integer.MAX_VALUE;
            } else {
                Event event1 = ((EventExpression)eventRef1).getEvent();
                order1 = this.order.get(event1);
            }
            if (eventRef2 instanceof TauExpression) {
                order2 = Integer.MAX_VALUE;
            } else {
                Event event2 = ((EventExpression)eventRef2).getEvent();
                order2 = this.order.get(event2);
            }
            return Integer.compare(order1, order2);
        }
    }

    private static class UpdateExprReplacer
    extends CifWalker {
        public final Expression sendValue;
        public boolean replaced = false;

        public UpdateExprReplacer(Expression sendValue) {
            this.sendValue = sendValue;
        }

        public void replace(Expression expr) {
            this.walkExpression(expr);
        }

        protected void walkReceivedExpression(ReceivedExpression expr) {
            Expression replacement = (Expression)EMFHelper.deepclone((EObject)this.sendValue);
            EMFHelper.updateParentContainment((EObject)expr, (EObject)replacement);
            this.replaced = true;
        }
    }
}

