/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.update;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.FilterManager;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.lite.edit.parts.update.ComposeableRefresherImpl;
import org.eclipse.gmf.runtime.lite.edit.parts.update.IExternallyUpdatableEditPart;
import org.eclipse.gmf.runtime.lite.edit.parts.update.IUpdatableEditPart;
import org.eclipse.gmf.runtime.lite.edit.parts.update.UpdaterUtil;
import org.eclipse.gmf.runtime.lite.edit.parts.update.canonical.INotationModelRefresher;
import org.eclipse.gmf.runtime.notation.CanonicalStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class TransactionalUpdateManager
extends ResourceSetListenerImpl {
    private final EditPartViewer myEditPartViewer;
    private final HashMap<EObject, Collection<IUpdatableEditPart>> myRegisteredListeners = new HashMap();
    private final NotationModelRefresherHolder myNotationModelRefreshers = new NotationModelRefresherHolder();
    private TransactionalEditingDomain myEditingDomain;

    public TransactionalUpdateManager(EditPartViewer editPartViewer) {
        this.myEditPartViewer = editPartViewer;
    }

    public void install(TransactionalEditingDomain editingDomain) {
        if (this.myEditingDomain != null) {
            throw new IllegalStateException("Already listening to an editing domain");
        }
        this.myEditingDomain = editingDomain;
        this.myEditingDomain.addResourceSetListener((ResourceSetListener)this);
    }

    public boolean isInstalled() {
        return this.myEditingDomain != null;
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.myEditingDomain.removeResourceSetListener((ResourceSetListener)this);
            this.myEditingDomain = null;
        }
    }

    public Command buildRefreshNotationModelCommand() {
        return this.myNotationModelRefreshers.buildNotationRefreshCommand();
    }

    public void addNotationModelRefresher(INotationModelRefresher refresher) {
        this.myNotationModelRefreshers.addNotationModelRefresher(refresher);
    }

    public void removeNotationModelRefresher(INotationModelRefresher refresher) {
        this.myNotationModelRefreshers.removeNotationModelRefresher(refresher);
    }

    public boolean isNotationModelRefresherInstalled(INotationModelRefresher refresher) {
        return this.myNotationModelRefreshers.isNotationModelRefresherInstalled(refresher);
    }

    public void addUpdatableEditPart(EObject source, IUpdatableEditPart listener) {
        if (source == null || listener == null) {
            return;
        }
        Collection<IUpdatableEditPart> listeners = this.myRegisteredListeners.get(source);
        if (listeners == null) {
            listeners = new LinkedList<IUpdatableEditPart>();
            this.myRegisteredListeners.put(source, listeners);
        }
        listeners.add(listener);
    }

    public void removeUpdatableEditPart(EObject source, IUpdatableEditPart listener) {
        if (source == null || listener == null) {
            return;
        }
        Collection<IUpdatableEditPart> listeners = this.myRegisteredListeners.get(source);
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
        if (listeners.isEmpty()) {
            this.myRegisteredListeners.remove(source);
        }
    }

    public void dispose() {
        this.myRegisteredListeners.clear();
        this.myNotationModelRefreshers.dispose();
    }

    protected final Collection<IUpdatableEditPart> getRegisteredListeners(EObject source) {
        return this.myRegisteredListeners.get(source);
    }

    protected final Collection<IUpdatableEditPart> getRegisteredListeners(Notification msg) {
        Collection<IUpdatableEditPart> result;
        Object notifier = msg.getNotifier();
        if (notifier instanceof EObject && (result = this.getRegisteredListeners((EObject)notifier)) != null) {
            return result;
        }
        return Collections.emptyList();
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        this.myNotationModelRefreshers.startRecording();
        try {
            this.executeRefreshers(event);
            Command command = this.myNotationModelRefreshers.buildNotationRefreshCommand(event);
            return command;
        }
        finally {
            this.myNotationModelRefreshers.stopRecording();
        }
    }

    private void executeRefreshers(ResourceSetChangeEvent event) {
        ComposeableRefresherImpl affectedRefreshers = new ComposeableRefresherImpl();
        for (Notification msg : event.getNotifications()) {
            Collection<IUpdatableEditPart> affectedEditParts = this.findAffectedParts(msg);
            for (IUpdatableEditPart next : affectedEditParts) {
                this.processRefreshers(affectedRefreshers, next, msg);
            }
            Collection<IUpdatableEditPart> registeredListeners = this.getRegisteredListeners(msg);
            for (IUpdatableEditPart next : registeredListeners) {
                this.processRefreshers(affectedRefreshers, next, msg);
            }
            if (!this.isCanonicalStyleEvent(msg)) continue;
            this.myNotationModelRefreshers.processCanonicalStyleEvent(msg);
        }
        affectedRefreshers.refresh();
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        if (event.getTransaction() == null) {
            return;
        }
        if (Boolean.TRUE.equals(event.getTransaction().getOptions().get("no_triggers"))) {
            this.executeRefreshers(event);
        }
        Iterator<EObject> it = this.myRegisteredListeners.keySet().iterator();
        while (it.hasNext()) {
            EObject next = it.next();
            if (next.eResource() != null) continue;
            it.remove();
        }
        this.myNotationModelRefreshers.removeStaleRefreshers();
    }

    public boolean isCanonicalStyleEvent(Notification msg) {
        if (NotationPackage.eINSTANCE.getCanonicalStyle_Canonical() == msg.getFeature()) {
            return msg.getNewBooleanValue();
        }
        if (NotationPackage.eINSTANCE.getView_Styles() == msg.getFeature() && UpdaterUtil.affects(msg, NotationPackage.eINSTANCE.getCanonicalStyle())) {
            CanonicalStyle style = (CanonicalStyle)((View)msg.getNotifier()).getStyle(NotationPackage.eINSTANCE.getCanonicalStyle());
            if (style == null) {
                return true;
            }
            return style.isCanonical();
        }
        return false;
    }

    protected void processRefreshers(ComposeableRefresherImpl affectedRefreshers, IUpdatableEditPart next, Notification msg) {
        if (next instanceof IExternallyUpdatableEditPart) {
            for (IExternallyUpdatableEditPart.ExternalRefresher nextExternalRefresher : ((IExternallyUpdatableEditPart)next).getExternalRefreshers()) {
                if (!nextExternalRefresher.isAffectingEvent(msg)) continue;
                affectedRefreshers.addRefresher(nextExternalRefresher);
            }
        }
        IUpdatableEditPart.Refresher refresher = next.getRefresher((EStructuralFeature)msg.getFeature(), msg);
        affectedRefreshers.addRefresher(refresher);
    }

    protected final EditPartViewer getEditPartViewer() {
        return this.myEditPartViewer;
    }

    protected Collection<IUpdatableEditPart> findAffectedParts(Notification msg) {
        View view;
        Object notifier = msg.getNotifier();
        if (notifier instanceof EObject && (view = this.getView((EObject)notifier)) != null) {
            EditPart affectedEditPart = (EditPart)this.myEditPartViewer.getEditPartRegistry().get(view);
            if (affectedEditPart instanceof IUpdatableEditPart) {
                if (this.shouldNotifyParent(msg) && affectedEditPart.getModel() == view && affectedEditPart.getParent() instanceof IUpdatableEditPart) {
                    return Arrays.asList((IUpdatableEditPart)affectedEditPart, (IUpdatableEditPart)affectedEditPart.getParent());
                }
                return Collections.singleton((IUpdatableEditPart)affectedEditPart);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    protected boolean shouldNotifyParent(Notification msg) {
        if (msg.getFeature() == NotationPackage.eINSTANCE.getView_Visible()) {
            return true;
        }
        if (msg.getFeature() == EcorePackage.eINSTANCE.getEModelElement_EAnnotations()) {
            return msg.getNotifier() instanceof View;
        }
        return false;
    }

    private View getView(EObject offspring) {
        while (offspring != null && (!(offspring instanceof View) || this.isFiltered((View)offspring))) {
            offspring = offspring.eContainer();
        }
        return (View)offspring;
    }

    protected boolean isFiltered(View view) {
        return !(this.myEditPartViewer.getEditPartRegistry().get(view) instanceof IUpdatableEditPart);
    }

    private static class NotationModelRefresherHolder {
        private final HashMap<View, Collection<INotationModelRefresher>> myListeners = new HashMap();
        private Set<INotationModelRefresher> myJustAddedListeners;

        private NotationModelRefresherHolder() {
        }

        void addNotationModelRefresher(INotationModelRefresher refresher) {
            if (refresher == null) {
                return;
            }
            View view = refresher.getView();
            if (view == null || view.eResource() == null) {
                return;
            }
            Collection<INotationModelRefresher> listeners = this.myListeners.get(view);
            if (listeners == null) {
                listeners = new LinkedList<INotationModelRefresher>();
                this.myListeners.put(view, listeners);
            }
            if (!listeners.contains(refresher)) {
                listeners.add(refresher);
            }
            if (this.myJustAddedListeners != null) {
                this.myJustAddedListeners.add(refresher);
            }
        }

        boolean isNotationModelRefresherInstalled(INotationModelRefresher refresher) {
            if (this.myJustAddedListeners != null && this.myJustAddedListeners.contains(refresher)) {
                return true;
            }
            if (refresher == null) {
                return false;
            }
            View view = refresher.getView();
            if (view == null) {
                return false;
            }
            Collection<INotationModelRefresher> listeners = this.myListeners.get(view);
            if (listeners == null) {
                return false;
            }
            return listeners.contains(refresher);
        }

        void processCanonicalStyleEvent(Notification msg) {
            assert (this.myJustAddedListeners != null);
            Collection<INotationModelRefresher> affectedRefreshers = this.myListeners.get(msg.getNotifier());
            if (affectedRefreshers != null) {
                this.myJustAddedListeners.addAll(affectedRefreshers);
            }
        }

        Command buildNotationRefreshCommand() {
            CompoundCommand result = new CompoundCommand();
            for (INotationModelRefresher next : this.getAllNotationModelRefreshers()) {
                Command refreshNotationModelCommand = next.buildRefreshNotationModelCommand();
                result.appendIfCanExecute(refreshNotationModelCommand);
            }
            return result.isEmpty() ? null : result;
        }

        Command buildNotationRefreshCommand(ResourceSetChangeEvent event) throws RollbackException {
            CompoundCommand result = new CompoundCommand();
            ArrayList cache = new ArrayList(event.getNotifications().size());
            for (INotationModelRefresher next : this.getAllNotationModelRefreshers()) {
                Command nextCommand;
                ResourceSetChangeEvent nextEvent;
                if (this.myJustAddedListeners.contains(next)) {
                    nextEvent = event;
                } else {
                    List filtered = FilterManager.getInstance().select(event.getNotifications(), next.getFilter(), cache);
                    if (filtered.isEmpty()) continue;
                    nextEvent = new ResourceSetChangeEvent(event.getEditingDomain(), event.getTransaction(), event.getNotifications());
                }
                if (nextEvent == null || (nextCommand = next.transactionAboutToCommit(nextEvent)) == null) continue;
                result.append(nextCommand);
            }
            return result.isEmpty() ? null : result;
        }

        void removeNotationModelRefresher(INotationModelRefresher refresher) {
            if (refresher == null) {
                return;
            }
            View view = refresher.getView();
            if (view == null) {
                return;
            }
            Collection<INotationModelRefresher> listeners = this.myListeners.get(view);
            if (listeners != null) {
                listeners.remove(refresher);
            }
            if (this.myJustAddedListeners != null) {
                this.myJustAddedListeners.remove(refresher);
            }
        }

        private Collection<INotationModelRefresher> getAllNotationModelRefreshers() {
            HashSet<INotationModelRefresher> result = new HashSet<INotationModelRefresher>();
            for (Collection<INotationModelRefresher> next : this.myListeners.values()) {
                if (next == null) continue;
                result.addAll(next);
            }
            return result;
        }

        void startRecording() {
            this.myJustAddedListeners = new HashSet<INotationModelRefresher>();
        }

        void stopRecording() {
            this.myJustAddedListeners.clear();
            this.myJustAddedListeners = null;
        }

        void removeStaleRefreshers() {
            Iterator<Map.Entry<View, Collection<INotationModelRefresher>>> it = this.myListeners.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<View, Collection<INotationModelRefresher>> next = it.next();
                if (next.getKey().eResource() != null) continue;
                it.remove();
            }
        }

        void dispose() {
            this.myListeners.clear();
        }
    }
}

