/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.ThreadAction;

public class ThreadTxn {
    public static ThreadAction threadTxn(Transactional trans, TxnType txnType, Runnable action) {
        return ThreadTxn.create(trans, txnType, action, true, true);
    }

    public static ThreadAction threadTxnRead(Transactional trans, Runnable action) {
        return ThreadTxn.threadTxn(trans, TxnType.READ, action);
    }

    public static ThreadAction threadTxnWrite(Transactional trans, Runnable action) {
        return ThreadTxn.threadTxn(trans, TxnType.WRITE, action);
    }

    public static ThreadAction threadTxnWriteAbort(Transactional trans, Runnable action) {
        return ThreadTxn.create(trans, TxnType.WRITE, action, true, false);
    }

    private static ThreadAction create(Transactional trans, TxnType txnType, Runnable action, boolean isCommitBefore, boolean isCommitAfter) {
        return ThreadAction.create(ThreadTxn.beforeAction(trans, txnType, isCommitBefore), action, ThreadTxn.afterAction(trans, txnType, isCommitAfter));
    }

    private static Runnable beforeAction(Transactional trans, TxnType txnType, boolean isCommit) {
        return () -> trans.begin(txnType);
    }

    private static Runnable afterAction(Transactional trans, TxnType txnType, boolean isCommit) {
        return () -> {
            switch (txnType) {
                case WRITE: 
                case READ_COMMITTED_PROMOTE: 
                case READ_PROMOTE: {
                    if (isCommit) {
                        trans.commit();
                    } else {
                        trans.abort();
                    }
                    trans.end();
                    break;
                }
                case READ: {
                    if (isCommit) {
                        trans.commit();
                    }
                    trans.end();
                }
            }
        };
    }
}

