/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.model;

import java.util.stream.Stream;
import org.apache.jena.ontapi.model.OntNamedProperty;
import org.apache.jena.ontapi.model.OntProperty;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;

public interface OntAnnotationProperty
extends OntProperty,
OntNamedProperty<OntAnnotationProperty> {
    public Stream<OntAnnotationProperty> subProperties(boolean var1);

    public Stream<OntAnnotationProperty> superProperties(boolean var1);

    public Stream<Resource> domains();

    public Stream<Resource> ranges();

    default public Stream<OntAnnotationProperty> subProperties() {
        return this.subProperties(false);
    }

    default public Stream<OntAnnotationProperty> superProperties() {
        return this.superProperties(false);
    }

    default public OntAnnotationProperty addRange(Resource uri) {
        this.addRangeStatement(uri);
        return this;
    }

    default public OntAnnotationProperty addDomain(Resource uri) {
        this.addDomainStatement(uri);
        return this;
    }

    @Override
    default public OntAnnotationProperty removeDomain(Resource domain) {
        this.remove(RDFS.domain, domain);
        return this;
    }

    @Override
    default public OntAnnotationProperty removeRange(Resource range) {
        this.remove(RDFS.range, range);
        return this;
    }

    default public OntAnnotationProperty addSuperProperty(OntAnnotationProperty property) {
        this.addSubPropertyOfStatement(property);
        return this;
    }

    default public OntAnnotationProperty addSubProperty(OntAnnotationProperty property) {
        property.addSubPropertyOfStatement(this);
        return this;
    }

    @Override
    default public OntAnnotationProperty removeSuperProperty(Resource property) {
        this.remove(RDFS.subPropertyOf, property);
        return this;
    }

    @Override
    default public OntAnnotationProperty removeSubProperty(Resource property) {
        this.getModel().statements(property, RDFS.subPropertyOf, this).toList().forEach(s -> this.getModel().remove(s.clearAnnotations()));
        return this;
    }
}

