/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.collection;

import org.apache.jena.mem2.collection.FastHashBase;
import org.apache.jena.mem2.collection.JenaSetHashOptimized;

public abstract class FastHashSet<K>
extends FastHashBase<K>
implements JenaSetHashOptimized<K> {
    protected FastHashSet(int initialSize) {
        super(initialSize);
    }

    protected FastHashSet() {
    }

    protected FastHashSet(FastHashSet<K> setToCopy) {
        super(setToCopy);
    }

    @Override
    public boolean tryAdd(K key) {
        return this.tryAdd(key, key.hashCode());
    }

    @Override
    public boolean tryAdd(K value, int hashCode) {
        this.growPositionsArrayIfNeeded();
        int pIndex = this.findPosition(value, hashCode);
        if (pIndex < 0) {
            int eIndex = this.getFreeKeyIndex();
            this.keys[eIndex] = value;
            this.hashCodesOrDeletedIndices[eIndex] = hashCode;
            this.positions[pIndex ^ 0xFFFFFFFF] = ~eIndex;
            return true;
        }
        return false;
    }

    public int addAndGetIndex(K value) {
        return this.addAndGetIndex(value, value.hashCode());
    }

    public int addAndGetIndex(K value, int hashCode) {
        this.growPositionsArrayIfNeeded();
        int pIndex = this.findPosition(value, hashCode);
        if (pIndex < 0) {
            int eIndex = this.getFreeKeyIndex();
            this.keys[eIndex] = value;
            this.hashCodesOrDeletedIndices[eIndex] = hashCode;
            this.positions[pIndex ^ 0xFFFFFFFF] = ~eIndex;
            return eIndex;
        }
        return this.positions[pIndex];
    }

    @Override
    public void addUnchecked(K key) {
        this.addUnchecked(key, key.hashCode());
    }

    @Override
    public void addUnchecked(K value, int hashCode) {
        this.growPositionsArrayIfNeeded();
        int eIndex = this.getFreeKeyIndex();
        this.keys[eIndex] = value;
        this.hashCodesOrDeletedIndices[eIndex] = hashCode;
        this.positions[this.findEmptySlotWithoutEqualityCheck((int)hashCode)] = ~eIndex;
    }

    public K getKeyAt(int i) {
        return (K)this.keys[i];
    }
}

