/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.introspection.java;

import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.util.SimulinkUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.introspection.java.ObjectMethod;

public class SimulinkObjectMethod
extends ObjectMethod {
    protected String name;
    protected MatlabEngine engine;

    public SimulinkObjectMethod(MatlabEngine engine, Object object, String name) {
        this.engine = engine;
        this.name = name;
        this.object = object;
    }

    public Object execute(Object[] parameters, ModuleElement ast) throws EolRuntimeException {
        String cmd = "";
        try {
            if (this.object instanceof ISimulinkModelElement) {
                cmd = SimulinkUtil.handleMethodWithResult((ISimulinkModelElement)this.object, this.name, parameters);
            }
            if (this.object instanceof SimulinkModel) {
                cmd = SimulinkUtil.handleMethodWithResult((SimulinkModel)((Object)this.object), this.name, parameters);
            }
            this.engine.eval(cmd);
            return this.engine.getVariable("result");
        }
        catch (MatlabException e) {
            if (e.isTooManyOutput()) {
                try {
                    if (this.object instanceof ISimulinkModelElement) {
                        cmd = SimulinkUtil.handleMethod((ISimulinkModelElement)this.object, this.name, parameters);
                    }
                    if (this.object instanceof SimulinkModel) {
                        cmd = SimulinkUtil.handleMethod((SimulinkModel)((Object)this.object), this.name, parameters);
                    }
                    this.engine.eval(cmd);
                    return null;
                }
                catch (MatlabException matlabException) {
                    return new EolRuntimeException(e.getMessage());
                }
            }
            return null;
        }
    }
}

