/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.modelmutator;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESModelMutatorConfiguration {
    private Collection<EPackage> modelPackages;
    private EObject rootEObject;
    private Random random;
    private Long seed;
    private int minObjectsCount;
    private Integer maxDeleteCount;
    private Integer mutationCount;
    private boolean ignoreAndLog;
    private Collection<EClass> eClassesToIgnore;
    private Collection<EStructuralFeature> eStructuralFeaturesToIgnore;
    private Set<RuntimeException> exceptionLog;
    private boolean doNotGenerateRoot;
    private boolean useEcoreUtilDelete;
    private boolean allowDuplicateIDs;
    private EditingDomain editingDomain;

    public ESModelMutatorConfiguration() {
        this((EPackage)null, (EObject)null, (Long)null);
    }

    public ESModelMutatorConfiguration(EPackage modelPackage, EObject rootEObject, Long seed) {
        this(Collections.singleton(modelPackage), rootEObject, seed);
    }

    public ESModelMutatorConfiguration(Collection<EPackage> modelPackages, EObject rootEObject, Long seed) {
        this.modelPackages = modelPackages;
        this.rootEObject = rootEObject;
        this.seed = seed;
        this.eClassesToIgnore = new LinkedHashSet<EClass>();
        this.eStructuralFeaturesToIgnore = new LinkedHashSet<EStructuralFeature>();
        this.exceptionLog = new LinkedHashSet<RuntimeException>();
        this.ignoreAndLog = false;
        this.minObjectsCount = 100;
        this.useEcoreUtilDelete = false;
    }

    public void reset() {
        this.random = null;
        this.editingDomain = null;
    }

    public void setModelPackages(Collection<EPackage> modelPackages) {
        this.modelPackages = modelPackages;
    }

    public void setRootEObject(EObject rootEObject) {
        this.rootEObject = rootEObject;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public int getMinObjectsCount() {
        return this.minObjectsCount;
    }

    public void setMinObjectsCount(int minObjectsCount) {
        this.minObjectsCount = minObjectsCount;
    }

    public boolean isIgnoreAndLog() {
        return this.ignoreAndLog;
    }

    public void setIgnoreAndLog(boolean ignoreAndLog) {
        this.ignoreAndLog = ignoreAndLog;
    }

    public Collection<EClass> geteClassesToIgnore() {
        return this.eClassesToIgnore;
    }

    public void seteClassesToIgnore(Collection<EClass> eClassesToIgnore) {
        this.eClassesToIgnore = eClassesToIgnore;
    }

    public Collection<EPackage> getModelPackages() {
        return this.modelPackages;
    }

    public EObject getRootEObject() {
        return this.rootEObject;
    }

    public Set<RuntimeException> getExceptionLog() {
        return this.exceptionLog;
    }

    public void setExceptionLog(Set<RuntimeException> exceptionLog) {
        this.exceptionLog = exceptionLog;
    }

    public Random getRandom() {
        if (this.random == null) {
            this.random = new Random(this.seed);
        }
        return this.random;
    }

    public Collection<EStructuralFeature> geteStructuralFeaturesToIgnore() {
        return this.eStructuralFeaturesToIgnore;
    }

    public void seteStructuralFeaturesToIgnore(Collection<EStructuralFeature> eStructuralFeaturesToIgnore) {
        this.eStructuralFeaturesToIgnore = eStructuralFeaturesToIgnore;
    }

    public boolean isDoNotGenerateRoot() {
        return this.doNotGenerateRoot;
    }

    public void setDoNotGenerateRoot(boolean doNotGenerateRoot) {
        this.doNotGenerateRoot = doNotGenerateRoot;
    }

    public EditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (CommandStack)new BasicCommandStack());
        }
        return this.editingDomain;
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public boolean isUseEcoreUtilDelete() {
        return this.useEcoreUtilDelete;
    }

    public void setUseEcoreUtilDelete(boolean useEcoreUtilDelete) {
        this.useEcoreUtilDelete = useEcoreUtilDelete;
    }

    public int getMaxDeleteCount() {
        return this.maxDeleteCount != null ? this.maxDeleteCount : this.minObjectsCount;
    }

    public void setMaxDeleteCount(Integer maxDeleteCount) {
        this.maxDeleteCount = maxDeleteCount;
    }

    public int getMutationCount() {
        return this.mutationCount != null ? this.mutationCount : -1;
    }

    public void setMutationCount(Integer mutationCount) {
        this.mutationCount = mutationCount;
    }

    public boolean isAllowDuplicateIDs() {
        return this.allowDuplicateIDs;
    }

    public void setAllowDuplicateIDs(boolean allowDuplicateIDs) {
        this.allowDuplicateIDs = allowDuplicateIDs;
    }
}

