/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.auth;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.Messages;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.ACUserContainer;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.SessionTimedOutException;
import org.eclipse.emf.emfstore.internal.server.model.AuthenticationInformation;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESAuthenticationInformationImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESSessionIdImpl;
import org.eclipse.emf.emfstore.server.model.ESAuthenticationInformation;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitId;
import org.eclipse.emf.emfstore.server.model.ESSessionId;
import org.eclipse.emf.emfstore.server.model.ESUser;

public class ESSessions {
    private final Map<SessionId, ACUserContainer> sessionUserMap = new LinkedHashMap<SessionId, ACUserContainer>();

    public void add(ESAuthenticationInformation authenticationInformation) {
        AuthenticationInformation authInfo = (AuthenticationInformation)((ESAuthenticationInformationImpl)ESAuthenticationInformationImpl.class.cast(authenticationInformation)).toInternalAPI();
        this.sessionUserMap.put(authInfo.getSessionId(), new ACUserContainer(authInfo.getResolvedACUser()));
    }

    public void isValid(ESSessionId sessionId) throws SessionTimedOutException {
        if (!this.sessionUserMap.containsKey(ESSessions.toInternalSession(sessionId))) {
            throw new SessionTimedOutException(Messages.AccessControlImpl_SessionID_Unknown);
        }
    }

    public ESUser resolveUser(ESSessionId sessionId) throws AccessControlException {
        Preconditions.checkNotNull((Object)sessionId, (Object)"sessionId must not be null");
        ACUserContainer container = this.sessionUserMap.get(ESSessions.toInternalSession(sessionId));
        if (container == null) {
            return null;
        }
        return (ESUser)container.getUser().toAPI();
    }

    public ESOrgUnitId resolveToOrgUnitId(ESSessionId sessionId) throws AccessControlException {
        Preconditions.checkNotNull((Object)sessionId, (Object)"sessionId must not be null");
        SessionId session = (SessionId)((ESSessionIdImpl)ESSessionIdImpl.class.cast(sessionId)).toInternalAPI();
        ACUserContainer container = this.sessionUserMap.get(session);
        if (container == null) {
            return null;
        }
        return (ESOrgUnitId)container.getUser().getId().toAPI();
    }

    public ESUser getRawUser(ESSessionId sessionId) {
        Preconditions.checkNotNull((Object)sessionId, (Object)"sessionId must not be null");
        return (ESUser)this.sessionUserMap.get(ESSessions.toInternalSession(sessionId)).getRawUser().toAPI();
    }

    public void remove(ESSessionId sessionId) {
        Preconditions.checkNotNull((Object)sessionId, (Object)"sessionId must not be null");
        this.sessionUserMap.remove(ESSessions.toInternalSession(sessionId));
    }

    public ESSessionId resolveSessionById(String sessionId) {
        Set<Map.Entry<SessionId, ACUserContainer>> entrySet = this.sessionUserMap.entrySet();
        for (Map.Entry<SessionId, ACUserContainer> entry : entrySet) {
            if (!entry.getKey().getId().equals(sessionId)) continue;
            return (ESSessionId)entry.getKey().toAPI();
        }
        return null;
    }

    private static SessionId toInternalSession(ESSessionId sessionId) {
        Preconditions.checkNotNull((Object)sessionId, (Object)"sessionId must not be null");
        return (SessionId)((ESSessionIdImpl)ESSessionIdImpl.class.cast(sessionId)).toInternalAPI();
    }
}

