/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.startup;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfstore.common.ESSystemOutProgressMonitor;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.migration.EMFStoreMigrationException;
import org.eclipse.emf.emfstore.internal.migration.EMFStoreMigrator;
import org.eclipse.emf.emfstore.internal.migration.EMFStoreMigratorUtil;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Version;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.Direction;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.SerializedOperationEmitter;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.OperationsPackage;
import org.eclipse.emf.emfstore.server.ESServerURIUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MigrationManager {
    private MigrationManager() {
    }

    public static void migrate(ResourceSet resourceSet, boolean inMemoryChangePackage) throws FatalESException {
        Set urisWhichNeedMigration;
        if (!EMFStoreMigratorUtil.isMigratorAvailable()) {
            return;
        }
        EMFStoreMigrator migrator = null;
        try {
            migrator = EMFStoreMigratorUtil.getEMFStoreMigrator();
        }
        catch (EMFStoreMigrationException eMFStoreMigrationException) {
            throw new FatalESException("No EMFStore Migrator could be created even though a migrator should be available.");
        }
        URI serverSpaceURI = ESServerURIUtil.createServerSpaceURI();
        Resource resource = resourceSet.createResource(serverSpaceURI);
        try {
            resource.load(null);
        }
        catch (IOException ex) {
            ModelUtil.logException((Throwable)ex);
            return;
        }
        ServerSpace serverSpace = (ServerSpace)resource.getContents().get(0);
        LinkedHashSet<URI> urisToMigrate = new LinkedHashSet<URI>();
        LinkedHashMap<URI, List<URI>> fileBasedCPToTempFiles = new LinkedHashMap<URI, List<URI>>();
        MigrationManager.fillURIsToMigrate(resourceSet.getURIConverter(), serverSpace, urisToMigrate, fileBasedCPToTempFiles, inMemoryChangePackage);
        Set urisWhichCantBeHandled = migrator.canHandle(urisToMigrate);
        if (!urisWhichCantBeHandled.isEmpty()) {
            urisToMigrate.removeAll(urisWhichCantBeHandled);
            for (URI uri : urisWhichCantBeHandled) {
                ModelUtil.logInfo((String)MessageFormat.format("No migrator found for URI {0}. If a migration is needed for this URI you may encounter problems.", uri));
            }
        }
        if ((urisWhichNeedMigration = migrator.needsMigration(urisToMigrate)).isEmpty()) {
            return;
        }
        try {
            migrator.migrate(urisWhichNeedMigration, (IProgressMonitor)new ESSystemOutProgressMonitor());
        }
        catch (EMFStoreMigrationException ex) {
            ModelUtil.logException((Throwable)ex);
        }
        MigrationManager.fixFileBasedCPs(fileBasedCPToTempFiles);
    }

    private static void fixFileBasedCPs(Map<URI, List<URI>> fileBasedCPToTempFiles) {
        for (URI fileBasedCPURI : fileBasedCPToTempFiles.keySet()) {
            FileBasedChangePackage changePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
            changePackage.initialize(fileBasedCPURI.toFileString());
            for (URI tempOperationFileURI : fileBasedCPToTempFiles.get(fileBasedCPURI)) {
                try {
                    AbstractOperation operation = (AbstractOperation)ModelUtil.loadEObjectFromResource((EClass)OperationsPackage.eINSTANCE.getAbstractOperation(), (URI)tempOperationFileURI, (boolean)false);
                    changePackage.add(operation);
                }
                catch (IOException ex) {
                    ModelUtil.logException((Throwable)ex);
                }
            }
            try {
                FileUtils.copyFile((File)new File(changePackage.getTempFilePath()), (File)new File(changePackage.getFilePath()));
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
            }
        }
    }

    private static void fillURIsToMigrate(URIConverter uriConverter, ServerSpace serverSpace, Set<URI> urisToMigrate, Map<URI, List<URI>> fileBasedCPToTempFiles, boolean inMemoryChangePackage) {
        for (ProjectHistory project : serverSpace.getProjects()) {
            for (Version version : project.getVersions()) {
                URI versionURI = EcoreUtil.getURI((EObject)version);
                URI projectStateURI = ESServerURIUtil.createProjectStateURI(versionURI);
                if (uriConverter.exists(projectStateURI, null)) {
                    urisToMigrate.add(uriConverter.normalize(projectStateURI));
                }
                URI changePackageURI = ESServerURIUtil.createChangePackageURI(versionURI);
                if (!inMemoryChangePackage) {
                    MigrationManager.fillURIsToMigrateForFileBasedCP(uriConverter, changePackageURI, urisToMigrate, fileBasedCPToTempFiles);
                    continue;
                }
                if (!uriConverter.exists(changePackageURI, null)) continue;
                urisToMigrate.add(uriConverter.normalize(changePackageURI));
            }
        }
    }

    private static void fillURIsToMigrateForFileBasedCP(URIConverter uriConverter, URI changePackageURI, Set<URI> urisToMigrate, Map<URI, List<URI>> fileBasedCPToTempFiles) {
        URI normalizedFileBasedChangePackageURI = uriConverter.normalize(changePackageURI);
        URI operationsFile = URI.createURI((String)(String.valueOf(normalizedFileBasedChangePackageURI.toString()) + ".1"));
        try {
            File operationsJavaFile = new File(operationsFile.toFileString());
            if (!operationsJavaFile.exists()) {
                return;
            }
            fileBasedCPToTempFiles.put(operationsFile, new ArrayList());
            SerializedOperationEmitter operationEmitter = new SerializedOperationEmitter(Direction.Forward, operationsJavaFile);
            Optional operation = operationEmitter.tryEmit();
            while (operation.isPresent()) {
                File tempFile = File.createTempFile("esMigration", ".xmi");
                tempFile.deleteOnExit();
                FileUtils.writeStringToFile((File)tempFile, (String)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + (String)operation.get()), (String)"UTF-8");
                URI tempFileURI = URI.createFileURI((String)tempFile.getAbsolutePath());
                urisToMigrate.add(tempFileURI);
                fileBasedCPToTempFiles.get(operationsFile).add(tempFileURI);
                operation = operationEmitter.tryEmit();
            }
            operationEmitter.close();
        }
        catch (IOException ex) {
            ModelUtil.logException((Throwable)ex);
        }
    }
}

