/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core.subinterfaces;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.Messages;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageEnvelope;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.ChangePackageUtil;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePackageFragmentProviderAdapter
extends AdapterImpl {
    private final Map<String, Map<Integer, List<String>>> proxyIdToChangePackageFragments = new LinkedHashMap<String, Map<Integer, List<String>>>();

    public void addAsFragments(String proxyId, FileBasedChangePackage changePackage) {
        Iterator envelopes = ChangePackageUtil.splitChangePackage((FileBasedChangePackage)changePackage, (int)((Integer)ServerConfiguration.getChangePackageFragmentSize().get()));
        while (envelopes.hasNext()) {
            this.addFragment(proxyId, (List<String>)((ChangePackageEnvelope)envelopes.next()).getFragment());
        }
    }

    private void addFragment(String proxyId, List<String> fragment) {
        Map<Integer, List<String>> map = this.proxyIdToChangePackageFragments.get(proxyId);
        if (map == null) {
            map = new LinkedHashMap<Integer, List<String>>();
            this.proxyIdToChangePackageFragments.put(proxyId, map);
        }
        int currentSize = map.size();
        map.put(currentSize, fragment);
    }

    public List<String> getFragment(String proxyId, int fragmentIndex) throws ESException {
        Map<Integer, List<String>> fragments = this.proxyIdToChangePackageFragments.get(proxyId);
        if (fragments == null) {
            throw new ESException(Messages.ChangePackageFragmentProviderAdapter_NoFragmentsFound);
        }
        return fragments.get(fragmentIndex);
    }

    public int getFragmentSize(String proxyId) {
        Map<Integer, List<String>> map = this.proxyIdToChangePackageFragments.get(proxyId);
        if (map == null) {
            return -1;
        }
        return map.size();
    }

    public void markAsConsumed(String proxyId) {
        this.proxyIdToChangePackageFragments.remove(proxyId);
    }
}

