/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.test.common;

import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.test.common.cases.ESTestWithLoggedInUserMock;
import org.eclipse.emf.emfstore.client.test.common.dsl.Add;
import org.eclipse.emf.emfstore.client.test.common.dsl.Create;
import org.eclipse.emf.emfstore.client.test.common.util.ProjectUtil;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageEnvelope;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.OperationsFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.ChangePackageUtil;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.test.model.TestElement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class ChangePackageUtilTest
extends ESTestWithLoggedInUserMock {
    private Optional<Integer> fragmentationSize;

    @BeforeClass
    public static void beforeClass() {
        ChangePackageUtilTest.startEMFStore();
    }

    @AfterClass
    public static void afterClass() {
        ChangePackageUtilTest.stopEMFStore();
    }

    public void before() {
        super.before();
        this.fragmentationSize = Configuration.getClientBehavior().getChangePackageFragmentSize();
        Configuration.getClientBehavior().setChangePackageFragmentSize(Optional.of((Object)1));
    }

    @After
    public void after() {
        Configuration.getClientBehavior().setChangePackageFragmentSize(this.fragmentationSize);
    }

    @Ignore
    @Test
    public void shouldEmitAtLeastOneElement() throws ESException {
        FileBasedChangePackage changePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        Iterator it = ChangePackageUtil.splitChangePackage((FileBasedChangePackage)changePackage, (int)1);
        Assert.assertTrue((boolean)it.hasNext());
        ChangePackageEnvelope next = (ChangePackageEnvelope)it.next();
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertEquals((long)0L, (long)next.getFragmentIndex());
        Assert.assertEquals((long)1L, (long)next.getFragmentCount());
    }

    @Test
    public void shouldAssertThatCallingHasNextOnTheReturnedIteratorHasNoSideEffect() throws ESException {
        ProjectUtil.share((ESUsersession)this.getUsersession(), (ESLocalProject)this.getLocalProject());
        TestElement foo = Create.testElement((String)"foo");
        TestElement bar = Create.testElement((String)"bar");
        TestElement baz = Create.testElement((String)"baz");
        Add.toProject((ESLocalProject)this.getLocalProject(), (EObject)foo);
        Add.toProject((ESLocalProject)this.getLocalProject(), (EObject)bar);
        Add.toProject((ESLocalProject)this.getLocalProject(), (EObject)baz);
        FileBasedChangePackage changePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        Iterator it = ChangePackageUtil.splitChangePackage((FileBasedChangePackage)changePackage, (int)2);
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertTrue((boolean)it.hasNext());
    }

    @Ignore
    @Test
    public void shouldSplitOperationsIntoChunks() throws ESException {
        ProjectUtil.share((ESUsersession)this.getUsersession(), (ESLocalProject)this.getLocalProject());
        TestElement foo = Create.testElement((String)"foo");
        TestElement bar = Create.testElement((String)"bar");
        TestElement baz = Create.testElement((String)"baz");
        Add.toProject((ESLocalProject)this.getLocalProject(), (EObject)foo);
        Add.toProject((ESLocalProject)this.getLocalProject(), (EObject)bar);
        Add.toProject((ESLocalProject)this.getLocalProject(), (EObject)baz);
        FileBasedChangePackage changePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        Iterator it = ChangePackageUtil.splitChangePackage((FileBasedChangePackage)changePackage, (int)2);
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((long)2L, (long)((ChangePackageEnvelope)it.next()).getFragment().size());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((long)1L, (long)((ChangePackageEnvelope)it.next()).getFragment().size());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Ignore
    @Test
    public void shouldSetIsLastFlagCorrectly() throws ESException {
        ProjectUtil.share((ESUsersession)this.getUsersession(), (ESLocalProject)this.getLocalProject());
        TestElement foo = Create.testElement((String)"foo");
        TestElement bar = Create.testElement((String)"bar");
        TestElement baz = Create.testElement((String)"baz");
        Add.toProject((ESLocalProject)this.getLocalProject(), (EObject)foo);
        Add.toProject((ESLocalProject)this.getLocalProject(), (EObject)bar);
        Add.toProject((ESLocalProject)this.getLocalProject(), (EObject)baz);
        FileBasedChangePackage changePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        Iterator it = ChangePackageUtil.splitChangePackage((FileBasedChangePackage)changePackage, (int)2);
        ChangePackageEnvelope firstFragment = (ChangePackageEnvelope)it.next();
        ChangePackageEnvelope secondFragment = (ChangePackageEnvelope)it.next();
        Assert.assertFalse((boolean)firstFragment.isLast());
        Assert.assertTrue((boolean)secondFragment.isLast());
    }

    @Ignore
    @Test
    public void shouldConsiderRootOperationBoundaries() {
        FileBasedChangePackage changePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        changePackage.add((AbstractOperation)ChangePackageUtilTest.createDummyCompositeOperation(3));
        Iterator iterator = ChangePackageUtil.splitChangePackage((FileBasedChangePackage)changePackage, (int)1);
        ChangePackageEnvelope next = (ChangePackageEnvelope)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((long)0L, (long)next.getFragmentIndex());
        Assert.assertTrue((boolean)next.isLast());
    }

    @Test
    public void shouldConsiderRootOperationBoundariesOfMultipleOperations() {
        FileBasedChangePackage changePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        changePackage.add((AbstractOperation)ChangePackageUtilTest.createDummyCompositeOperation(3));
        changePackage.add((AbstractOperation)ChangePackageUtilTest.createDummyCompositeOperation(2));
        changePackage.add((AbstractOperation)ChangePackageUtilTest.createDummyCompositeOperation(6));
        Iterator iterator = ChangePackageUtil.splitChangePackage((FileBasedChangePackage)changePackage, (int)5);
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)2L, (long)((ChangePackageEnvelope)iterator.next()).getFragmentCount());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)((ChangePackageEnvelope)iterator.next()).isLast());
    }

    @Ignore
    @Test(expected=NoSuchElementException.class)
    public void shouldThrowNoSuchElementException() {
        FileBasedChangePackage changePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        Iterator iterator = ChangePackageUtil.splitChangePackage((FileBasedChangePackage)changePackage, (int)5);
        Assert.assertTrue((boolean)((ChangePackageEnvelope)iterator.next()).isLast());
        iterator.next();
    }

    private static CompositeOperation createDummyCompositeOperation(int subOpsSize) {
        CompositeOperation compositeOperation = OperationsFactory.eINSTANCE.createCompositeOperation();
        int i = 0;
        while (i < subOpsSize) {
            CreateDeleteOperation dummyOp = OperationsFactory.eINSTANCE.createCreateDeleteOperation();
            compositeOperation.getSubOperations().add((Object)dummyOp);
            ++i;
        }
        return compositeOperation;
    }
}

